/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import xaero.common.gui.GuiDropdownHelper;
import xaero.common.gui.KeySortableByOther;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.minimap.waypoints.WaypointsManager;

public class GuiWaypointWorlds
extends GuiDropdownHelper {
    public GuiWaypointWorlds(WaypointWorldContainer wc, WaypointsManager waypointsManager, String currentWorld) {
        String a = waypointsManager.getAutoContainerID() + "_" + waypointsManager.getAutoWorldID();
        this.current = -1;
        this.auto = -1;
        ArrayList<KeySortableByOther<String>> keysList = new ArrayList<KeySortableByOther<String>>();
        HashMap<String, String> nameMap = new HashMap<String, String>();
        this.addWorlds(wc, a, keysList, nameMap);
        Collections.sort(keysList);
        ArrayList<String> keysStringList = new ArrayList<String>();
        ArrayList<String> optionsList = new ArrayList<String>();
        for (int j = 0; j < keysList.size(); ++j) {
            KeySortableByOther<String> keySortable = keysList.get(j);
            String key = keySortable.getKey();
            if (this.current == -1 && key.equals(currentWorld)) {
                this.current = j;
            }
            String option = "Error";
            try {
                if (this.auto == -1 && key.equals(a)) {
                    this.auto = j;
                }
                option = nameMap.get(key);
                if (this.auto == j) {
                    option = option + " (auto)";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            keysStringList.add(key);
            optionsList.add(option);
        }
        if (this.current == -1) {
            this.current = 0;
        }
        this.keys = keysStringList.toArray(new String[0]);
        this.options = optionsList.toArray(new String[0]);
    }

    private void addWorlds(WaypointWorldContainer wc, String a, ArrayList<KeySortableByOther<String>> keysList, HashMap<String, String> nameMap) {
        String[] worldKeys = wc.worlds.keySet().toArray(new String[0]);
        for (int j = 0; j < worldKeys.length; ++j) {
            String worldKey = worldKeys[j];
            String containerName = wc.getSubName();
            String worldName = wc.getFullName(worldKey, containerName);
            String fullKey = wc.getKey() + "_" + worldKey;
            int firstNameSpace = worldName.indexOf(32);
            String firstNameWord = firstNameSpace != -1 ? worldName.substring(0, firstNameSpace) : "";
            int firstNameWordAsInt = 0;
            try {
                firstNameWordAsInt = Integer.parseInt(firstNameWord);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            keysList.add(new KeySortableByOther<String>(fullKey, new Comparable[]{containerName.toLowerCase(), Integer.valueOf(firstNameWordAsInt), worldName.toLowerCase()}));
            nameMap.put(fullKey, worldName);
        }
        WaypointWorldContainer[] subContainers = wc.subContainers.values().toArray(new WaypointWorldContainer[0]);
        for (int i = 0; i < subContainers.length; ++i) {
            this.addWorlds(subContainers[i], a, keysList, nameMap);
        }
    }

    public String[] getCurrentKeys() {
        String fullKey = this.getCurrentKey();
        return new String[]{fullKey.substring(0, fullKey.lastIndexOf("_")), fullKey.substring(fullKey.lastIndexOf("_") + 1)};
    }
}

