/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.core;

import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.network.play.server.SPacketMultiBlockChange;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.Chunk;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.core.IXaeroMinimapClientPlayNetHandler;
import xaero.patreon.Patreon4;

public class XaeroMinimapCore {
    public static IXaeroMinimap modMain;
    public static Field chunkCleanField;

    public static void ensureField() {
        if (chunkCleanField == null) {
            try {
                chunkCleanField = Chunk.class.getDeclaredField("xaero_chunkClean");
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void chunkUpdateCallback(int chunkX, int chunkZ) {
        XaeroMinimapCore.ensureField();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            try {
                for (int x = chunkX - 1; x < chunkX + 2; ++x) {
                    for (int z = chunkZ - 1; z < chunkZ + 2; ++z) {
                        Chunk chunk = world.func_72964_e(x, z);
                        if (chunk == null) continue;
                        chunkCleanField.set(chunk, false);
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void onChunkData(SPacketChunkData packetIn) {
        XaeroMinimapCore.chunkUpdateCallback(packetIn.func_149273_e(), packetIn.func_149271_f());
    }

    public static void onBlockChange(SPacketBlockChange packetIn) {
        XaeroMinimapCore.chunkUpdateCallback(packetIn.func_179827_b().func_177958_n() >> 4, packetIn.func_179827_b().func_177952_p() >> 4);
    }

    public static void onMultiBlockChange(SPacketMultiBlockChange packetIn) {
        XaeroMinimapCore.chunkUpdateCallback(packetIn.func_179844_a()[0].func_180090_a().func_177958_n() >> 4, packetIn.func_179844_a()[0].func_180090_a().func_177952_p() >> 4);
    }

    public static ResourceLocation getPlayerCape(AbstractClientPlayer player) {
        return Patreon4.getPlayerCape(modMain.getFileLayoutID(), player);
    }

    public static Boolean isWearing(EntityPlayer player, EnumPlayerModelParts part) {
        if (part != EnumPlayerModelParts.CAPE || !(player instanceof AbstractClientPlayer)) {
            return null;
        }
        return Patreon4.isWearingCape(modMain.getFileLayoutID(), (AbstractClientPlayer)player);
    }

    public static void onPlayNetHandler(NetHandlerPlayClient netHandler) {
        XaeroMinimapSession minimapSession = modMain.createSession();
        try {
            minimapSession.init();
            ((IXaeroMinimapClientPlayNetHandler)netHandler).setXaero_minimapSession(minimapSession);
        }
        catch (Throwable e) {
            RuntimeException wrappedException = new RuntimeException("Exception initializing Xaero's Minimap! ", e);
            modMain.getInterfaces().getMinimapInterface().setCrashedWith(wrappedException);
            Minecraft.func_71410_x().field_71441_e.func_72882_A();
        }
    }

    public static void onPlayNetHandlerCleanup(NetHandlerPlayClient netHandler) {
        try {
            ((IXaeroMinimapClientPlayNetHandler)netHandler).getXaero_minimapSession().cleanup();
        }
        catch (Throwable e) {
            RuntimeException wrappedException = new RuntimeException("Exception finalizing Xaero's Minimap! ", e);
            modMain.getInterfaces().getMinimapInterface().setCrashedWith(wrappedException);
        }
    }

    static {
        chunkCleanField = null;
    }
}

