/*
 * Decompiled with CFR 0.152.
 */
package xaero.common;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import xaero.common.IXaeroMinimap;
import xaero.common.controls.ControlsHandler;
import xaero.common.controls.event.KeyEventHandler;
import xaero.common.interfaces.Interface;
import xaero.common.interfaces.InterfaceInstance;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.MinimapRadar;
import xaero.common.minimap.waypoints.WaypointSharingHandler;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.waypoints.render.WaypointsGuiRenderer;
import xaero.common.minimap.waypoints.render.WaypointsIngameRenderer;
import xaero.common.minimap.write.MinimapWriter;

public class XaeroMinimapSession {
    protected IXaeroMinimap modMain;
    protected WaypointsManager waypointsManager;
    protected WaypointSharingHandler waypointSharing;
    protected ControlsHandler controls;
    protected KeyEventHandler keyEventHandler;
    protected WaypointsGuiRenderer waypointsGuiRenderer;
    protected WaypointsIngameRenderer waypointsIngameRenderer;
    protected MinimapProcessor minimap;
    protected Map<Interface, InterfaceInstance> interfaceInstances;

    public XaeroMinimapSession(IXaeroMinimap modMain) {
        this.modMain = modMain;
    }

    public void init() throws IOException {
        this.waypointsManager = new WaypointsManager(this.modMain, this);
        this.modMain.getSettings().loadWaypointsFromAllSources(this.waypointsManager);
        this.waypointSharing = new WaypointSharingHandler(this.modMain, this);
        this.keyEventHandler = new KeyEventHandler();
        MinimapWriter minimapWriter = new MinimapWriter(this.modMain, this);
        MinimapRadar entityRadar = new MinimapRadar(this.modMain, this);
        this.minimap = new MinimapProcessor(this.modMain, this, minimapWriter, entityRadar);
        this.interfaceInstances = new HashMap<Interface, InterfaceInstance>();
        Iterator<Interface> interfaces = this.modMain.getInterfaces().getInterfaceIterator();
        while (interfaces.hasNext()) {
            Interface inter = interfaces.next();
            this.interfaceInstances.put(inter, inter.createInterfaceInstance(this));
        }
        System.out.println("New minimap session initialized!");
    }

    public void cleanup() {
        this.minimap.cleanup();
        Iterator<Interface> interfaces = this.modMain.getInterfaces().getInterfaceIterator();
        while (interfaces.hasNext()) {
            Interface inter = interfaces.next();
            this.interfaceInstances.get(inter).cleanup();
        }
        System.out.println("Minimap session finalized.");
    }

    public WaypointsManager getWaypointsManager() {
        return this.waypointsManager;
    }

    public WaypointSharingHandler getWaypointSharing() {
        return this.waypointSharing;
    }

    public ControlsHandler getControls() {
        return this.controls;
    }

    public KeyEventHandler getKeyEventHandler() {
        return this.keyEventHandler;
    }

    public MinimapProcessor getMinimapProcessor() {
        return this.minimap;
    }

    public Map<Interface, InterfaceInstance> getInterfaceInstances() {
        return this.interfaceInstances;
    }
}

