/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.command.util.PermissionCondition;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.AbstractPlatform;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.MultiUserPlatform;
import com.sk89q.worldedit.extension.platform.Preference;
import com.sk89q.worldedit.forge.CommandWrapper;
import com.sk89q.worldedit.forge.ForgeConfiguration;
import com.sk89q.worldedit.forge.ForgeDataFixer;
import com.sk89q.worldedit.forge.ForgePlayer;
import com.sk89q.worldedit.forge.ForgeRegistries;
import com.sk89q.worldedit.forge.ForgeResourceLoader;
import com.sk89q.worldedit.forge.ForgeWatchdog;
import com.sk89q.worldedit.forge.ForgeWorld;
import com.sk89q.worldedit.forge.ForgeWorldEdit;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.io.ResourceLoader;
import com.sk89q.worldedit.world.DataFixer;
import com.sk89q.worldedit.world.registry.Registries;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;

class ForgePlatform
extends AbstractPlatform
implements MultiUserPlatform {
    private final ForgeWorldEdit mod;
    private final MinecraftServer server;
    private final ForgeDataFixer dataFixer;
    @Nullable
    private final ForgeWatchdog watchdog;
    private boolean hookingEvents = false;
    private final ResourceLoader resourceLoader = new ForgeResourceLoader(WorldEdit.getInstance());
    private static final Set<SideEffect> SUPPORTED_SIDE_EFFECTS = Sets.immutableEnumSet((Enum)SideEffect.VALIDATION, (Enum[])new SideEffect[]{SideEffect.ENTITY_AI, SideEffect.LIGHTING, SideEffect.NEIGHBORS, SideEffect.EVENTS});

    ForgePlatform(ForgeWorldEdit mod) {
        this.mod = mod;
        this.server = ServerLifecycleHooks.getCurrentServer();
        this.dataFixer = new ForgeDataFixer(this.getDataVersion());
        this.watchdog = this.server instanceof DedicatedServer ? new ForgeWatchdog((DedicatedServer)this.server) : null;
    }

    boolean isHookingEvents() {
        return this.hookingEvents;
    }

    @Override
    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Override
    public Registries getRegistries() {
        return ForgeRegistries.getInstance();
    }

    @Override
    public int getDataVersion() {
        return SharedConstants.func_215069_a().getWorldVersion();
    }

    @Override
    public DataFixer getDataFixer() {
        return this.dataFixer;
    }

    @Override
    public boolean isValidMobType(String type) {
        return net.minecraftforge.registries.ForgeRegistries.ENTITIES.containsKey(new ResourceLocation(type));
    }

    @Override
    public void reload() {
        this.getConfiguration().load();
        super.reload();
    }

    @Override
    public int schedule(long delay, long period, Runnable task) {
        return -1;
    }

    @Override
    @Nullable
    public ForgeWatchdog getWatchdog() {
        return this.watchdog;
    }

    @Override
    public List<? extends com.sk89q.worldedit.world.World> getWorlds() {
        Iterable worlds = this.server.func_212370_w();
        ArrayList<ForgeWorld> ret = new ArrayList<ForgeWorld>();
        for (ServerWorld world : worlds) {
            ret.add(new ForgeWorld((World)world));
        }
        return ret;
    }

    @Override
    @Nullable
    public Player matchPlayer(Player player) {
        if (player instanceof ForgePlayer) {
            return player;
        }
        ServerPlayerEntity entity = this.server.func_184103_al().func_152612_a(player.getName());
        return entity != null ? new ForgePlayer(entity) : null;
    }

    @Override
    @Nullable
    public com.sk89q.worldedit.world.World matchWorld(com.sk89q.worldedit.world.World world) {
        if (world instanceof ForgeWorld) {
            return world;
        }
        for (ServerWorld ws : this.server.func_212370_w()) {
            if (!((IServerWorldInfo)ws.func_72912_H()).func_76065_j().equals(world.getName())) continue;
            return new ForgeWorld((World)ws);
        }
        return null;
    }

    @Override
    public void registerCommands(CommandManager manager) {
        if (this.server == null) {
            return;
        }
        Commands mcMan = this.server.func_195571_aL();
        for (Command command : manager.getAllCommands().collect(Collectors.toList())) {
            CommandWrapper.register((CommandDispatcher<CommandSource>)mcMan.func_197054_a(), command);
            Set perms = command.getCondition().as(PermissionCondition.class).map(PermissionCondition::getPermissions).orElseGet(Collections::emptySet);
            if (perms.isEmpty()) continue;
            perms.forEach(ForgeWorldEdit.inst.getPermissionsProvider()::registerPermission);
        }
    }

    @Override
    public void registerGameHooks() {
        this.hookingEvents = true;
    }

    @Override
    public ForgeConfiguration getConfiguration() {
        return this.mod.getConfig();
    }

    @Override
    public String getVersion() {
        return this.mod.getInternalVersion();
    }

    @Override
    public String getPlatformName() {
        return "Forge-Official";
    }

    @Override
    public String getPlatformVersion() {
        return this.mod.getInternalVersion();
    }

    @Override
    public Map<Capability, Preference> getCapabilities() {
        EnumMap<Capability, Preference> capabilities = new EnumMap<Capability, Preference>(Capability.class);
        capabilities.put(Capability.CONFIGURATION, Preference.PREFER_OTHERS);
        capabilities.put(Capability.WORLDEDIT_CUI, Preference.NORMAL);
        capabilities.put(Capability.GAME_HOOKS, Preference.NORMAL);
        capabilities.put(Capability.PERMISSIONS, Preference.NORMAL);
        capabilities.put(Capability.USER_COMMANDS, Preference.NORMAL);
        capabilities.put(Capability.WORLD_EDITING, Preference.PREFERRED);
        return capabilities;
    }

    @Override
    public Set<SideEffect> getSupportedSideEffects() {
        return SUPPORTED_SIDE_EFFECTS;
    }

    @Override
    public Collection<Actor> getConnectedUsers() {
        ArrayList<Actor> users = new ArrayList<Actor>();
        PlayerList scm = this.server.func_184103_al();
        for (ServerPlayerEntity entity : scm.func_181057_v()) {
            if (entity == null) continue;
            users.add(new ForgePlayer(entity));
        }
        return users;
    }
}

