/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard.io.legacycompat;

import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.extent.clipboard.io.legacycompat.NBTCompatibilityHandler;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.registry.LegacyMapper;
import java.util.Map;

public class FlowerPotCompatibilityHandler
implements NBTCompatibilityHandler {
    @Override
    public <B extends BlockStateHolder<B>> boolean isAffectedBlock(B block) {
        return block.getBlockType() == BlockTypes.FLOWER_POT;
    }

    @Override
    public <B extends BlockStateHolder<B>> BlockStateHolder<?> updateNBT(B block, Map<String, Tag> values) {
        Tag item = values.get("Item");
        if (item instanceof StringTag) {
            BlockState newState;
            String id = ((StringTag)item).getValue();
            if (id.isEmpty()) {
                return BlockTypes.FLOWER_POT.getDefaultState();
            }
            int data = 0;
            Tag dataTag = values.get("Data");
            if (dataTag instanceof IntTag) {
                data = ((IntTag)dataTag).getValue();
            }
            if ((newState = this.convertLegacyBlockType(id, data)) != null) {
                values.clear();
                return newState;
            }
        }
        return block;
    }

    private BlockState convertLegacyBlockType(String id, int data) {
        BlockType potAndPlanted;
        int newId = 0;
        switch (id) {
            case "minecraft:red_flower": {
                newId = 38;
                break;
            }
            case "minecraft:yellow_flower": {
                newId = 37;
                break;
            }
            case "minecraft:sapling": {
                newId = 6;
                break;
            }
            case "minecraft:deadbush": 
            case "minecraft:tallgrass": {
                newId = 31;
                break;
            }
        }
        String plantedName = null;
        if (newId == 0 && id.startsWith("minecraft:")) {
            plantedName = id.substring(10);
        } else {
            BlockState plantedWithData = LegacyMapper.getInstance().getBlockFromLegacy(newId, data);
            if (plantedWithData != null) {
                plantedName = plantedWithData.getBlockType().getId().substring(10);
            }
        }
        if (plantedName != null && (potAndPlanted = BlockTypes.get("minecraft:potted_" + plantedName)) != null) {
            return potAndPlanted.getDefaultState();
        }
        return null;
    }
}

