/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.plugins.vanilla;

import java.util.List;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.TooltipPosition;
import net.darkhax.wawla.lib.Feature;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class FeatureVillagerProfession
extends Feature
implements IEntityComponentProvider,
IServerDataProvider<Entity> {
    private static final ResourceLocation TIER = new ResourceLocation("wawla", "villager_tier");
    private static final ResourceLocation TIER_PROGRESS = new ResourceLocation("wawla", "villager_tier_progress");

    @Override
    public void initialize(IRegistrar hwyla) {
        hwyla.addConfig(TIER, true);
        hwyla.addConfig(TIER_PROGRESS, true);
        hwyla.registerComponentProvider((IEntityComponentProvider)this, TooltipPosition.BODY, VillagerEntity.class);
        hwyla.registerComponentProvider((IEntityComponentProvider)this, TooltipPosition.HEAD, VillagerEntity.class);
        hwyla.registerEntityDataProvider((IServerDataProvider)this, VillagerEntity.class);
    }

    public void appendServerData(CompoundNBT nbt, ServerPlayerEntity player, World world, Entity target) {
        if (target instanceof VillagerEntity) {
            VillagerEntity villager = (VillagerEntity)target;
            CompoundNBT villagerData = new CompoundNBT();
            int level = villager.func_213700_eh().func_221132_c();
            villagerData.func_74768_a("level", level);
            villagerData.func_74768_a("curExp", villager.func_213708_dV());
            villagerData.func_74768_a("targetExp", VillagerData.func_221127_c((int)level));
            villagerData.func_74757_a("hasTrades", !villager.func_213706_dY().isEmpty());
            nbt.func_218657_a("WAWLAVillager", (INBT)villagerData);
        }
    }

    public void appendHead(List<ITextComponent> info, IEntityAccessor accessor, IPluginConfig config) {
        int level;
        CompoundNBT data;
        if (accessor.getServerData().func_74764_b("WAWLAVillager") && accessor.getEntity() != null && !accessor.getEntity().func_145818_k_() && (data = accessor.getServerData().func_74775_l("WAWLAVillager")).func_74767_n("hasTrades") && config.get(TIER) && (level = data.func_74762_e("level")) > 0 && level <= 5) {
            info.set(0, (ITextComponent)new TranslationTextComponent("info.wawla.villager.name", new Object[]{new TranslationTextComponent("merchant.level." + level), accessor.getEntity().func_145748_c_()}));
        }
    }

    public void appendBody(List<ITextComponent> info, IEntityAccessor accessor, IPluginConfig config) {
        if (accessor.getEntity() instanceof VillagerEntity && accessor.getServerData().func_74764_b("WAWLAVillager")) {
            VillagerEntity villager = (VillagerEntity)accessor.getEntity();
            CompoundNBT data = accessor.getServerData().func_74775_l("WAWLAVillager");
            if (data.func_74767_n("hasTrades")) {
                int level;
                if (config.get(TIER) && villager.func_145818_k_() && (level = data.func_74762_e("level")) > 0 && level <= 5) {
                    ResourceLocation profId = villager.func_213700_eh().func_221130_b().getRegistryName();
                    TranslationTextComponent professionName = new TranslationTextComponent(villager.func_200600_R().func_210760_d() + '.' + (!"minecraft".equals(profId.func_110624_b()) ? profId.func_110624_b() + '.' : "") + profId.func_110623_a());
                    info.add((ITextComponent)new TranslationTextComponent("info.wawla.profession", new Object[]{new TranslationTextComponent("merchant.level." + level), professionName}));
                }
                if (config.get(TIER_PROGRESS)) {
                    int curXp = data.func_74762_e("curExp");
                    int targetXp = data.func_74762_e("targetExp");
                    if (targetXp > 0) {
                        info.add((ITextComponent)new TranslationTextComponent("info.wawla.villager.exp", new Object[]{curXp, targetXp}));
                    }
                }
            }
        }
    }
}

