/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.framework.json.recipe.smelting;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.registry.implement.IPostInit;
import com.builtbroken.mc.debug.IJsonDebugDisplay;
import com.builtbroken.mc.framework.json.data.JsonRecipeData;
import com.builtbroken.mc.framework.json.imp.IJsonGenObject;
import com.builtbroken.mc.framework.json.imp.IJsonProcessor;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import net.minecraft.item.ItemStack;

public class JsonFurnaceRecipeData
extends JsonRecipeData
implements IJsonGenObject,
IPostInit,
IJsonDebugDisplay {
    public final Object input;
    public float xp;

    public JsonFurnaceRecipeData(IJsonProcessor processor, Object input, Object output, float xp) {
        super(processor, output);
        this.input = input;
        this.xp = xp;
    }

    @Override
    public void onPostInit() {
        ItemStack outputStack = this.toStack(this.output);
        ItemStack inputStack = this.toStack(this.input);
        if (outputStack != null && outputStack.func_77973_b() != null) {
            if (inputStack != null && inputStack.func_77973_b() != null) {
                GameRegistry.addSmelting((ItemStack)inputStack, (ItemStack)outputStack, (float)this.xp);
            } else {
                Engine.logger().error("JsonSmeltingRecipe: Failed to parse input for " + this);
            }
        } else {
            Engine.logger().error("JsonSmeltingRecipe: Failed to parse output for " + this);
        }
    }

    @Override
    public String toString() {
        return "JsonFurnaceRecipe[" + this.input + " -> " + this.output + "]";
    }

    @Override
    public String getContentID() {
        return this.input.toString();
    }

    @Override
    public String getDisplayName() {
        return this.getContentID();
    }

    @Override
    public void addDebugLines(List<String> lines) {
        lines.add("Input: " + this.toStack(this.input));
        lines.add("Output: " + this.toStack(this.output));
        lines.add("Xp: " + this.xp);
    }
}

