/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven;

import com.builtbroken.jlib.lang.StringHelpers;
import com.builtbroken.mc.abstraction.EngineLoader;
import com.builtbroken.mc.api.VoltzEngineAPI;
import com.builtbroken.mc.api.event.TriggerCauseRegistry;
import com.builtbroken.mc.api.process.IWorkerThread;
import com.builtbroken.mc.api.recipe.MachineRecipeType;
import com.builtbroken.mc.core.ConfigValues;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.References;
import com.builtbroken.mc.core.asm.ProxyASMTest;
import com.builtbroken.mc.core.commands.CommandVE;
import com.builtbroken.mc.core.content.blast.tnt.ExplosiveHandlerTNT;
import com.builtbroken.mc.core.content.blocks.BlockHeatedStone;
import com.builtbroken.mc.core.content.debug.ItemDevData;
import com.builtbroken.mc.core.content.entity.ItemExEntitySpawnEgg;
import com.builtbroken.mc.core.content.parts.CraftingParts;
import com.builtbroken.mc.core.content.parts.ItemCircuits;
import com.builtbroken.mc.core.content.parts.ItemCraftingParts;
import com.builtbroken.mc.core.content.resources.DefinedGenItems;
import com.builtbroken.mc.core.content.resources.GenMaterial;
import com.builtbroken.mc.core.content.resources.items.ItemGenMaterial;
import com.builtbroken.mc.core.content.resources.load.CastRecipeLoader;
import com.builtbroken.mc.core.content.resources.load.CrusherRecipeLoad;
import com.builtbroken.mc.core.content.resources.load.FluidSmelterRecipeLoad;
import com.builtbroken.mc.core.content.resources.load.GearRecipeLoader;
import com.builtbroken.mc.core.content.resources.load.GrinderRecipeLoad;
import com.builtbroken.mc.core.content.resources.load.NuggetRecipeLoader;
import com.builtbroken.mc.core.content.resources.load.PlateRecipeLoader;
import com.builtbroken.mc.core.content.resources.load.RodRecipeLoader;
import com.builtbroken.mc.core.content.resources.load.ScrewRecipeLoader;
import com.builtbroken.mc.core.content.resources.load.SmeltingRecipeLoad;
import com.builtbroken.mc.core.content.resources.load.WireRecipeLoader;
import com.builtbroken.mc.core.content.tool.ItemScrewdriver;
import com.builtbroken.mc.core.content.tool.ItemSheetMetalTools;
import com.builtbroken.mc.core.content.tool.ItemSimpleCraftingTool;
import com.builtbroken.mc.core.content.tool.screwdriver.ToolMode;
import com.builtbroken.mc.core.content.tool.screwdriver.ToolModeGeneral;
import com.builtbroken.mc.core.content.tool.screwdriver.ToolModeRotation;
import com.builtbroken.mc.core.content.world.DevWorldLoader;
import com.builtbroken.mc.core.handler.InteractionHandler;
import com.builtbroken.mc.core.handler.SaveManager;
import com.builtbroken.mc.core.handler.TileTaskTickHandler;
import com.builtbroken.mc.core.registry.ModManager;
import com.builtbroken.mc.framework.entity.effect.EntityEffectHandler;
import com.builtbroken.mc.framework.entity.effect.effects.BleedingEffect;
import com.builtbroken.mc.framework.explosive.ExplosiveRegistry;
import com.builtbroken.mc.framework.explosive.TriggerNBTBuilder;
import com.builtbroken.mc.framework.json.JsonContentLoader;
import com.builtbroken.mc.framework.json.event.JsonEntryCreationEvent;
import com.builtbroken.mc.framework.json.override.JsonOverrideProcessor;
import com.builtbroken.mc.framework.json.processors.event.JsonMissingMapEventProcessor;
import com.builtbroken.mc.framework.json.processors.explosive.JsonProcessorExplosive;
import com.builtbroken.mc.framework.json.processors.multiblock.JsonMultiBlockLayoutProcessor;
import com.builtbroken.mc.framework.json.settings.JsonSettingsProcessor;
import com.builtbroken.mc.framework.mod.AbstractProxy;
import com.builtbroken.mc.framework.multiblock.BlockMultiblock;
import com.builtbroken.mc.framework.multiblock.EnumMultiblock;
import com.builtbroken.mc.framework.multiblock.ItemBlockMulti;
import com.builtbroken.mc.framework.recipe.cast.MRHandlerCast;
import com.builtbroken.mc.framework.recipe.fluid.MRHandlerFluidStack;
import com.builtbroken.mc.framework.recipe.item.MRHandlerItemStack;
import com.builtbroken.mc.framework.recipe.item.MRSmelterHandler;
import com.builtbroken.mc.framework.recipe.item.RecipeTool;
import com.builtbroken.mc.framework.recipe.item.grid.RecipeShapedOreLarge;
import com.builtbroken.mc.framework.recipe.item.sheetmetal.RecipeSheetMetal;
import com.builtbroken.mc.framework.thread.WorkerThread;
import com.builtbroken.mc.framework.thread.action.WorldActionQue;
import com.builtbroken.mc.framework.thread.delay.DelayedActionHandler;
import com.builtbroken.mc.lib.data.ItemStackMap;
import com.builtbroken.mc.lib.data.ItemStackToStackMap;
import com.builtbroken.mc.lib.data.heat.HeatedBlockRegistry;
import com.builtbroken.mc.lib.data.mass.MassRegistry;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.lib.helper.PotionUtility;
import com.builtbroken.mc.lib.helper.ReflectionUtility;
import com.builtbroken.mc.lib.world.edit.PlacementData;
import com.builtbroken.mc.lib.world.edit.PlacementDataExtended;
import com.builtbroken.mc.lib.world.map.radar.RadarRegistry;
import com.builtbroken.mc.lib.world.map.radio.RadioRegistry;
import com.builtbroken.mc.lib.world.map.tile.TileMapRegistry;
import com.builtbroken.mc.prefab.tile.TileEvents;
import com.builtbroken.mc.prefab.tile.item.ItemBlockMetadata;
import com.builtbroken.mc.seven.CommonProxy;
import com.builtbroken.mc.seven.framework.block.json.JsonBlockListenerProcessor;
import com.builtbroken.mc.seven.framework.block.json.JsonBlockProcessor;
import com.builtbroken.mc.seven.framework.block.json.JsonBlockTileProcessor;
import com.builtbroken.mc.seven.framework.block.listeners.AdjacentPlacementListener;
import com.builtbroken.mc.seven.framework.block.listeners.MultiBlockListener;
import com.builtbroken.mc.seven.framework.block.listeners.PathPlacementListener;
import com.builtbroken.mc.seven.framework.block.listeners.RenderBoundsListener;
import com.builtbroken.mc.seven.framework.block.listeners.RotatableListener;
import com.builtbroken.mc.seven.framework.block.listeners.WrenchRotationListener;
import com.builtbroken.mc.seven.framework.json.extra.JsonOreNameProcessor;
import com.builtbroken.mc.seven.framework.json.item.JsonItemProcessor;
import com.builtbroken.mc.seven.framework.json.recipe.crafting.JsonCraftingRecipeProcessor;
import com.builtbroken.mc.seven.framework.json.recipe.replace.JsonRecipeReplacementProcessor;
import com.builtbroken.mc.seven.framework.json.recipe.smelting.JsonFurnaceRecipeProcessor;
import com.builtbroken.mc.seven.framework.json.world.JsonWorldOreGenProcessor;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import org.apache.logging.log4j.Logger;

@Mod(modid="voltzengine", name="Voltz Engine", version="1.9.14.302", dependencies="required-after:Forge;after:TConstruct")
public class ModLoader
extends EngineLoader {
    @SidedProxy(clientSide="com.builtbroken.mc.seven.client.ClientProxy", serverSide="com.builtbroken.mc.seven.server.ServerProxy")
    public static CommonProxy proxy;
    @Deprecated
    public static final ModManager contentRegistry;
    @Mod.Metadata(value="voltzengine")
    public static ModMetadata metadata;
    @Mod.Instance(value="voltzengine")
    public static ModLoader instance;
    public ModManager manager;
    public static Configuration config;
    public static int actionProcessorThreads;
    public static boolean enabledHeatMap;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Engine.loaderInstance = this;
        proxy.onLoad();
        VoltzEngineAPI.massRegistry = new MassRegistry();
        References.GLOBAL_CONFIG_FOLDER = event.getModConfigurationDirectory();
        References.ROOT_FOLDER = References.GLOBAL_CONFIG_FOLDER.getParentFile();
        References.BBM_CONFIG_FOLDER = new File(event.getModConfigurationDirectory(), "bbm");
        config = References.configuration = new Configuration(new File(References.BBM_CONFIG_FOLDER, "ve/VoltzEngine.cfg"));
        References.heatDataConfig = new Configuration(new File(event.getModConfigurationDirectory(), "bbm/ve/HeatMap.cfg"));
        References.explosiveConfig = new Configuration(new File(event.getModConfigurationDirectory(), "bbm/ve/Explosives.cfg"));
        this.manager = new ModManager().setPrefix("voltzengine").setTab(CreativeTabs.field_78027_g);
        config.load();
        References.heatDataConfig.load();
        References.explosiveConfig.load();
        if (config.getBoolean("FurnaceRecipe_MapFix", "BugFixes", true, "Uses reflection to change the data map storing furnace recipes to prevent null entries from existing. This is implemented to fix bugs introduced by other mods.")) {
            Map previous = FurnaceRecipes.func_77602_a().func_77599_b();
            if (previous.getClass() == HashMap.class) {
                try {
                    Field field = ReflectionUtility.getMCField(FurnaceRecipes.class, "field_77604_b", "smeltingList");
                    field.setAccessible(true);
                    field.set(FurnaceRecipes.func_77602_a(), previous);
                    field.set(FurnaceRecipes.func_77602_a(), new ItemStackToStackMap("furnace recipe map", previous));
                }
                catch (Exception e2) {
                    ModLoader.logger().error("Failed to change Minecraft furnace recipe map to a ItemStackToStackMap in order to prevent invalid entries from being registered.", (Throwable)e2);
                }
            } else {
                ModLoader.logger().error("Furnace recipe map has already been replaced by '" + previous.getClass() + "' canceling replacement to avoid mod conflict.");
            }
        }
        if (config.getBoolean("FurnaceExperience_MapFix", "BugFixes", true, "Uses reflection to change the data map storing furnace recipes to prevent null entries from existing. This is implemented to fix bugs introduced by other mods.")) {
            try {
                Field field = ReflectionUtility.getMCField(FurnaceRecipes.class, "field_77605_c", "experienceList");
                field.setAccessible(true);
                Map previous = (Map)field.get(FurnaceRecipes.func_77602_a());
                if (previous.getClass() == HashMap.class) {
                    field.set(FurnaceRecipes.func_77602_a(), new ItemStackMap("furnace experience map", previous));
                } else {
                    ModLoader.logger().error("Furnace experience map has already been replaced by '" + previous.getClass() + "' canceling replacement to avoid mod conflict.");
                }
            }
            catch (Exception e3) {
                ModLoader.logger().error("Failed to change Minecraft furnace experience map to a ItemStackMap in order to prevent invalid entries from being registered.", (Throwable)e3);
            }
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        MinecraftForge.EVENT_BUS.register((Object)SaveManager.instance());
        MinecraftForge.EVENT_BUS.register((Object)new InteractionHandler());
        MinecraftForge.EVENT_BUS.register((Object)TileEvents.instance);
        MinecraftForge.EVENT_BUS.register((Object)RadarRegistry.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)RadarRegistry.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)TileMapRegistry.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)TileMapRegistry.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)RadioRegistry.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)RadioRegistry.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)new WorldActionQue());
        FMLCommonHandler.instance().bus().register((Object)TileTaskTickHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)proxy);
        FMLCommonHandler.instance().bus().register((Object)new DelayedActionHandler());
        enabledHeatMap = References.heatDataConfig.getBoolean("EnabledHeatMap", "general", true, "Heat map handles interaction of heat based energy and the world. Disable only if it causes issues or you want to reduce world file size. If disabled it can prevent machines from working.");
        ConfigValues.log_registering_explosives = References.explosiveConfig.getBoolean("EnableRegisterLogging", "general", false, "Adds debug each time a mod registers an explosive handler. Should only be enabled to figure out which mod is overriding another mod's explosive");
        MachineRecipeType.ITEM_SMELTER.setHandler(new MRSmelterHandler());
        MachineRecipeType.ITEM_GRINDER.setHandler(new MRHandlerItemStack(MachineRecipeType.ITEM_GRINDER.INTERNAL_NAME));
        MachineRecipeType.ITEM_CRUSHER.setHandler(new MRHandlerItemStack(MachineRecipeType.ITEM_CRUSHER.INTERNAL_NAME));
        MachineRecipeType.ITEM_WASHER.setHandler(new MRHandlerItemStack(MachineRecipeType.ITEM_WASHER.INTERNAL_NAME));
        MachineRecipeType.ITEM_SAWMILL.setHandler(new MRHandlerItemStack(MachineRecipeType.ITEM_SAWMILL.INTERNAL_NAME));
        MachineRecipeType.FLUID_SMELTER.setHandler(new MRHandlerFluidStack(MachineRecipeType.FLUID_SMELTER.INTERNAL_NAME));
        MachineRecipeType.FLUID_CAST.setHandler(new MRHandlerCast());
        RecipeSorter.register((String)"voltzengine:sheetMetalTools", RecipeSheetMetal.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
        RecipeSorter.register((String)"voltzengine:Tools", RecipeTool.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
        RecipeSorter.register((String)"voltzengine:shapedLarge", RecipeShapedOreLarge.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
        if (config.getBoolean("ASMTestingEnabled", "Internal", true, "Enables the testing of the internally used ASM code, used to ensure quality of the game. Only disable if you know the ASM is functional or there are issues with it running. Normally though if the ASM test fails then the ASM code itself was not injected. Which will result in several features of the mod not functioning correctly.")) {
            loader.applyModule(new ProxyASMTest());
        }
        loader.applyModule(this.getProxy());
        loader.applyModule(Engine.packetHandler);
        this.loadHandler();
        loader.applyModule(SmeltingRecipeLoad.class);
        loader.applyModule(CrusherRecipeLoad.class);
        loader.applyModule(GrinderRecipeLoad.class);
        loader.applyModule(FluidSmelterRecipeLoad.class);
        loader.applyModule(CastRecipeLoader.class);
        loader.applyModule(GearRecipeLoader.class);
        loader.applyModule(RodRecipeLoader.class);
        loader.applyModule(PlateRecipeLoader.class);
        loader.applyModule(NuggetRecipeLoader.class);
        loader.applyModule(WireRecipeLoader.class);
        loader.applyModule(ScrewRecipeLoader.class);
        TriggerCauseRegistry.register("entity", new TriggerNBTBuilder("entity"));
        TriggerCauseRegistry.register("impactEntity", new TriggerNBTBuilder("impactEntity"));
        TriggerCauseRegistry.register("entityImpactBlock", new TriggerNBTBuilder("entityImpactBlock"));
        TriggerCauseRegistry.register("entityImpactEntity", new TriggerNBTBuilder("entityImpactEntity"));
        TriggerCauseRegistry.register("explosion", new TriggerNBTBuilder("explosion"));
        TriggerCauseRegistry.register("fire", new TriggerNBTBuilder("fire"));
        TriggerCauseRegistry.register("redstone", new TriggerNBTBuilder("redstone"));
        if (Engine.runningAsDev) {
            loader.applyModule(new DevWorldLoader());
        }
        PotionUtility.resizePotionArray();
        CommandVE.disableCommands = this.getConfig().getBoolean("DisableServerCommands", "Commands", false, "Turns off all commands built into Voltz Engine");
        CommandVE.disableButcherCommand = this.getConfig().getBoolean("DisableButcherCommands", "Commands", false, "Turns off butcher command");
        CommandVE.disableClearCommand = this.getConfig().getBoolean("DisableClearCommands", "Commands", false, "Turns off clear command");
        CommandVE.disableRemoveCommand = this.getConfig().getBoolean("DisableRemoverCommands", "Commands", false, "Turns off remove command");
        ConfigValues.enableExtendedMetaPacketSync = this.getConfig().getBoolean("EnableExtendedBlockMetaPacketSync", "Map_data", true, "While on extended meta values will be synced to the client. Can be disabled on both sides to save on bandwidth but will result in rendering issues if disabled.");
        ToolMode.REGISTRY.add(new ToolModeGeneral());
        ToolMode.REGISTRY.add(new ToolModeRotation());
        if (this.getConfig().get("Content", "LoadDevDataTool", Engine.runningAsDev, "This is a developer tool for checking data on blocks and tile").getBoolean(Engine.runningAsDev)) {
            Engine.itemDevTool = contentRegistry.newItem("ve.devTool", new ItemDevData());
        }
        if (this.getConfig().get("Content", "LoadScrewDriver", true, "Basic tool for configuring, rotating, and picking up machines.").getBoolean(true)) {
            Engine.itemWrench = this.getManager().newItem("ve.screwdriver", new ItemScrewdriver());
        }
        ExplosiveRegistry.registerOrGetExplosive("voltzengine", "TNT", new ExplosiveHandlerTNT());
        int tntValue = 8;
        ExplosiveRegistry.registerExplosiveItem(new ItemStack(Blocks.field_150335_W), ExplosiveRegistry.get("TNT"), 8.0);
        ExplosiveRegistry.registerExplosiveItem(new ItemStack(Items.field_151016_H), ExplosiveRegistry.get("TNT"), 1.6);
        ExplosiveRegistry.registerExplosiveItem(new ItemStack(Items.field_151144_bL, 1, 4), ExplosiveRegistry.get("TNT"), 0.8);
        EntityEffectHandler.addEffectCreator("bleeding", e -> new BleedingEffect((Entity)e));
        loader.preInit();
        JsonContentLoader.INSTANCE.claimContent(this);
        this.getManager().newItem("exSpawnEgg", new ItemExEntitySpawnEgg());
    }

    @SubscribeEvent
    public void referenceData(JsonEntryCreationEvent entryCreationEvent) {
        if (entryCreationEvent.object instanceof Item && "veSheetMetal".equalsIgnoreCase(entryCreationEvent.id)) {
            Engine.itemSheetMetal = (Item)entryCreationEvent.object;
        }
    }

    @Override
    public void loadJsonContentHandlers() {
        JsonContentLoader.INSTANCE.add(new JsonBlockProcessor());
        JsonContentLoader.INSTANCE.add(new JsonBlockTileProcessor());
        JsonContentLoader.INSTANCE.add(new JsonMultiBlockLayoutProcessor());
        JsonContentLoader.INSTANCE.add(new JsonItemProcessor());
        JsonContentLoader.INSTANCE.add(new JsonOreNameProcessor());
        JsonContentLoader.INSTANCE.add(new JsonCraftingRecipeProcessor());
        JsonContentLoader.INSTANCE.add(new JsonFurnaceRecipeProcessor());
        JsonContentLoader.INSTANCE.add(new JsonRecipeReplacementProcessor());
        JsonContentLoader.INSTANCE.add(new JsonWorldOreGenProcessor());
        JsonContentLoader.INSTANCE.add(new JsonOverrideProcessor());
        JsonContentLoader.INSTANCE.add(new JsonMissingMapEventProcessor());
        JsonContentLoader.INSTANCE.add(new JsonProcessorExplosive());
        JsonContentLoader.INSTANCE.add(JsonSettingsProcessor.INSTANCE);
        JsonBlockListenerProcessor.addBuilder(new RotatableListener.Builder());
        JsonBlockListenerProcessor.addBuilder(new MultiBlockListener.Builder());
        JsonBlockListenerProcessor.addBuilder(new WrenchRotationListener.Builder());
        JsonBlockListenerProcessor.addBuilder(new RenderBoundsListener.Builder());
        JsonBlockListenerProcessor.addBuilder(new AdjacentPlacementListener.Builder());
        JsonBlockListenerProcessor.addBuilder(new PathPlacementListener.Builder());
        this.getProxy().loadJsonContentHandlers();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        boolean forceLoadCraftingParts;
        ModLoader.metadata.modId = "Voltz Engine";
        ModLoader.metadata.name = "Voltz Engine";
        ModLoader.metadata.description = "Voltz Engine is a content creation toolkit";
        ModLoader.metadata.url = "http://www.builtbroken.com";
        ModLoader.metadata.version = "1.9.14.302";
        ModLoader.metadata.authorList = Arrays.asList("DarkCow");
        ModLoader.metadata.autogenerated = false;
        if (Engine.multiBlockRequested) {
            Engine.multiBlock = new BlockMultiblock();
            GameRegistry.registerBlock((Block)Engine.multiBlock, ItemBlockMulti.class, (String)"veMultiBlock");
            EnumMultiblock.register();
        }
        boolean forceLoadSheetMetal = (Engine.sheetMetalRequested || this.getConfig().hasKey("SheetMetalContent", "ForceLoad")) && this.getConfig().getBoolean("ForceLoad", "SheetMetalContent", true, "Forces the sheet metal items to load even if not requests. Content can still loaded if false as long as another mod requests the content for crafting. This config is designed to prevent items from vanishing in saves.");
        boolean forceLoadSimpleTools = (Engine.simpleToolsRequested || this.getConfig().hasKey("SimpleToolsContent", "ForceLoad")) && this.getConfig().getBoolean("ForceLoad", "SimpleToolsContent", true, "Forces the simple tools items to load even if not requests. Content can still loaded if false as long as another mod requests the content for crafting. This config is designed to prevent items from vanishing in saves.");
        boolean forceLoadCircuits = (Engine.circuitsRequested || this.getConfig().hasKey("Content", "LoadCircuits")) && this.getConfig().getBoolean("LoadCircuits", "Content", true, "Forces the circuit items to load even if not requests. Content can still loaded if false as long as another mod requests the content for crafting. This config is designed to prevent items from vanishing in saves.");
        boolean bl = forceLoadCraftingParts = (Engine.craftingPartsRequested || this.getConfig().hasKey("Content", "LoadCraftingParts")) && this.getConfig().getBoolean("LoadCraftingParts", "Content", true, "Forces the crafting items(Motors, coils, simple electrical parts) to load even if not requests. Content can still loaded if false as long as another mod requests the content for crafting. This config is designed to prevent items from vanishing in saves.");
        if (Engine.sheetMetalRequested || forceLoadSheetMetal) {
            Engine.itemSheetMetalTools = this.getManager().newItem("veSheetMetalTools", ItemSheetMetalTools.class, new Object[0]);
        }
        if (Engine.circuitsRequested || forceLoadCircuits) {
            Engine.itemCircuits = this.getManager().newItem("veCircuits", ItemCircuits.class, new Object[0]);
        }
        if (Engine.craftingPartsRequested || forceLoadCraftingParts) {
            Engine.itemCraftingParts = this.getManager().newItem("veCraftingParts", ItemCraftingParts.class, new Object[0]);
            for (CraftingParts part : CraftingParts.values()) {
                OreDictionary.registerOre((String)part.oreName, (ItemStack)part.toStack());
            }
        }
        if (Engine.simpleToolsRequested || forceLoadSimpleTools) {
            Engine.itemSimpleCraftingTools = this.getManager().newItem("veSimpleTools", ItemSimpleCraftingTool.class, new Object[0]);
        }
        if (this.getConfig().getBoolean("LoadHeatedRocks", "Content", Engine.heatedRockRequested, "Loads up heated rocks which are used to give explosions an extra short term effect on stone.")) {
            Engine.heatedStone = contentRegistry.newBlock("VEHeatedRock", BlockHeatedStone.class, (Class<? extends ItemBlock>)ItemBlockMetadata.class);
            if (enabledHeatMap) {
                HeatedBlockRegistry.addNewHeatingConversion(Blocks.field_150348_b, (PlacementData)new PlacementDataExtended(Engine.heatedStone, 15, Block.func_149682_b((Block)Blocks.field_150348_b)), 600);
                HeatedBlockRegistry.addNewHeatingConversion(Blocks.field_150347_e, (PlacementData)new PlacementDataExtended(Engine.heatedStone, 15, Block.func_149682_b((Block)Blocks.field_150347_e)), 600);
            }
        } else {
            HeatedBlockRegistry.addNewHeatingConversion(Blocks.field_150348_b, new PlacementData(Blocks.field_150347_e, 1), 600);
        }
        Engine.logger().info("Starting resource generator");
        long start = System.nanoTime();
        for (DefinedGenItems genItem : DefinedGenItems.values()) {
            if ((!this.getConfig().hasKey("ForceLoadContent", genItem.name) && !genItem.isRequested() || !this.getConfig().getBoolean(genItem.name, "ForceLoadContent", genItem.isRequested(), "Forces the items to load even if not requests. Content can still loaded if false as long as another mod requests the content for crafting. This config is designed to prevent items from vanishing in saves.")) && !genItem.isRequested()) continue;
            Engine.logger().info("\tGenerating " + genItem.name);
            genItem.item = this.getManager().newItem("ve" + LanguageUtility.capitalizeFirst(genItem.name), new ItemGenMaterial(genItem));
            for (GenMaterial mat : GenMaterial.values()) {
                if (mat == GenMaterial.UNKNOWN || genItem.ignoreMaterials.contains((Object)mat)) continue;
                OreDictionary.registerOre((String)(genItem.oreDict + LanguageUtility.capitalizeFirst(mat.name().toLowerCase())), (ItemStack)genItem.stack(mat));
            }
            if (genItem != DefinedGenItems.INGOT || !this.getConfig().getBoolean("EnableCheapSteelRecipe", "Content", true, "Enables iron ingot to steel ingot smelting recipe. Only disable if another recipe for steel exists or most items will be uncraftable.")) continue;
            GameRegistry.addSmelting((Item)Items.field_151042_j, (ItemStack)genItem.stack(GenMaterial.STEEL), (float)0.0f);
        }
        Engine.logger().info("Done... Took " + StringHelpers.formatTimeDifference((long)start, (long)System.nanoTime()));
        loader.init();
        this.getManager().fireInit();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        if (enabledHeatMap) {
            HeatedBlockRegistry.init(References.heatDataConfig);
        }
        loader.postInit();
        this.getManager().firePostInit();
        actionProcessorThreads = this.getConfig().getInt("WorldActionThreads", "Multi-Threading", Runtime.getRuntime().availableProcessors() - 1, 0, 100, "Creates the number of threads to be used for processing changes to the world. Used by mods like ICBM to calculate explosives before removing blocks from the world. Try to keep this one less than the number of processors you have. This way minecraft is not chocked out for CPU time.");
        References.heatDataConfig.save();
        References.explosiveConfig.save();
        this.getConfig().save();
    }

    @Mod.EventHandler
    public void loadCompleteEvent(FMLLoadCompleteEvent event) {
        String[] oreNames;
        loader.loadComplete();
        long time = System.nanoTime();
        Engine.logger().error("Checking ore dictionary for bad values");
        for (String name : oreNames = OreDictionary.getOreNames()) {
            ArrayList stacks = OreDictionary.getOres((String)name);
            if (stacks != null) {
                for (ItemStack stack : stacks) {
                    if (stack == null) {
                        Engine.logger().error("\tFound null stack value for ore dictionary value '" + name + "'");
                        continue;
                    }
                    if (stack.func_77973_b() != null) continue;
                    Engine.logger().error("\tFound null item value for stack '" + stack + "' for ore dictionary value '" + name + "'");
                }
                continue;
            }
            Engine.logger().error("\tFound bad ore dictionary value ore_name='" + name + "' containing no items, this can cause issues");
        }
        time = System.nanoTime() - time;
        Engine.logger().error("Done.... took: " + StringHelpers.formatNanoTime((long)time));
        if (Engine.runningAsDev) {
            Engine.logger().error("Injecting 3 bad values into furnace recipes to test error removal system works.");
            GameRegistry.addSmelting((ItemStack)null, (ItemStack)null, (float)1.0f);
            GameRegistry.addSmelting((ItemStack)new ItemStack((Block)null, 1, 1), (ItemStack)null, (float)1.0f);
            GameRegistry.addSmelting((ItemStack)new ItemStack((Item)null, 1, 1), (ItemStack)null, (float)1.0f);
        }
        time = System.nanoTime();
        Engine.logger().error("Checking furnace recipes for bad values. Will remove broken values to prevent crashes in VE and other mods depending on non-null data.");
        Iterator it = FurnaceRecipes.func_77602_a().func_77599_b().entrySet().iterator();
        int errorCount = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (entry.getKey() == null) {
                Engine.logger().error("\tFound null input stack value with output of " + entry.getValue());
                it.remove();
                ++errorCount;
                continue;
            }
            if (((ItemStack)entry.getKey()).func_77973_b() == null) {
                Engine.logger().error("\tFound null input stack item value with output of " + entry.getValue());
                it.remove();
                ++errorCount;
                continue;
            }
            if (entry.getValue() == null) {
                Engine.logger().error("\tFound null output stack value with input of " + entry.getKey());
                it.remove();
                ++errorCount;
                continue;
            }
            if (((ItemStack)entry.getValue()).func_77973_b() != null) continue;
            Engine.logger().error("\tFound null output stack item value with input of " + entry.getKey());
            it.remove();
            ++errorCount;
        }
        time = System.nanoTime() - time;
        Engine.logger().error("Done.... took: " + StringHelpers.formatNanoTime((long)time) + " detected " + errorCount + " bad recipes");
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        if (!CommandVE.disableCommands) {
            ICommandManager commandManager = FMLCommonHandler.instance().getMinecraftServerInstance().func_71187_D();
            ServerCommandManager serverCommandManager = (ServerCommandManager)commandManager;
            serverCommandManager.func_71560_a((ICommand)CommandVE.INSTANCE);
        }
        for (int i = 0; i < actionProcessorThreads; ++i) {
            WorkerThread thread = new WorkerThread("" + i);
            thread.start();
        }
        MinecraftForge.EVENT_BUS.register((Object)EntityEffectHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)EntityEffectHandler.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        ConcurrentHashMap<String, IWorkerThread> concurrentHashMap = VoltzEngineAPI.WORKER_THREADS;
        synchronized (concurrentHashMap) {
            for (IWorkerThread thread : VoltzEngineAPI.WORKER_THREADS.values()) {
                ModLoader.logger().info("Killing thread " + thread);
                thread.kill();
            }
        }
    }

    @Mod.EventHandler
    public void missingMappingEvent(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping missingMapping : event.getAll()) {
            String name = missingMapping.name;
            String key = null;
            if (name.startsWith("VoltzEngine:")) {
                key = "voltzengine:" + name.split(":")[1];
                key = key.replace("VoltzEngine", "ve");
            } else if (JsonMissingMapEventProcessor.mappings.containsKey(name)) {
                key = JsonMissingMapEventProcessor.mappings.get(name);
            }
            if (key == null || key.isEmpty()) continue;
            Engine.logger().info("Fixing missing mapping for '" + name + "' replacing with '" + key + "'");
            Object object = missingMapping.type.getRegistry().func_82594_a(key);
            if (object == Blocks.field_150350_a || object == null) {
                object = missingMapping.type.getRegistry().func_82594_a(key);
            }
            if (object == Blocks.field_150350_a || object == null) continue;
            if (object instanceof Block) {
                missingMapping.remap((Block)object);
                continue;
            }
            if (!(object instanceof Item)) continue;
            missingMapping.remap((Item)object);
        }
    }

    public AbstractProxy getProxy() {
        return proxy;
    }

    @Override
    public Configuration getConfig() {
        return config;
    }

    @Override
    public ModManager getManager() {
        return this.manager;
    }

    @Deprecated
    public static Logger logger() {
        return Engine.logger();
    }

    static {
        contentRegistry = new ModManager().setPrefix("voltzengine:").setTab(CreativeTabs.field_78040_i);
        actionProcessorThreads = 3;
        enabledHeatMap = true;
    }
}

