/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.gui.components;

import com.builtbroken.mc.prefab.gui.components.CallbackGuiArray;
import com.builtbroken.mc.prefab.gui.components.GuiComponent;
import com.builtbroken.mc.prefab.gui.components.GuiComponentContainer;
import com.builtbroken.mc.prefab.gui.components.GuiScrollBar;
import com.builtbroken.mc.prefab.gui.pos.GuiRelativePos;
import com.builtbroken.mc.prefab.gui.pos.HugXSide;
import com.builtbroken.mc.prefab.gui.pos.size.GuiRelativeSize;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;

public class GuiArray
extends GuiComponentContainer<GuiArray> {
    private int entriesShown = 0;
    private GuiScrollBar scrollBar;
    private GuiComponent[] buttonEntries;
    private CallbackGuiArray callback;
    private int entryCount = -1;
    private int ySpacing = 20;

    public GuiArray(CallbackGuiArray callback, int id, int x, int y, int entries) {
        this(callback, id, x, y, entries, 20);
    }

    public GuiArray(CallbackGuiArray callback, int id, int x, int y, int entries, int ySpacing) {
        super(id, x, y, 200, entries * ySpacing, "");
        this.resizeAsNeeded = false;
        this.ySpacing = ySpacing;
        this.callback = callback;
        this.scrollBar = this.add(new GuiScrollBar(0, new HugXSide((GuiComponent)this, -9, false), this.getHeight(), entries));
        this.scrollBar.setRelativeSize(new GuiRelativeSize(this, 9, 0).setUseHostWidth(false));
        this.setEntriesShown(entries);
    }

    @Override
    protected Color getBackgroundColor() {
        return enableDebug ? Color.MAGENTA : null;
    }

    @Override
    protected void update(Minecraft mc, int mouseX, int mouseY) {
        super.update(mc, mouseX, mouseY);
        if (this.entryCount != this.callback.getSize()) {
            this.entryCount = this.callback.getSize();
            this.reloadEntries();
            this.scrollBar.setMaxScroll(this.callback.getSize() - this.entriesShown);
        }
        if (this.entriesShown > this.entryCount) {
            this.scrollBar.downButton.disable();
        }
    }

    public void reloadEntries() {
        int i;
        if (this.buttonEntries == null) {
            this.buttonEntries = new GuiComponent[this.entriesShown];
            for (i = 0; i < this.buttonEntries.length; ++i) {
                this.buttonEntries[i] = this.add(this.callback.newEntry(i, i + 10, this.field_146128_h, this.field_146129_i));
                this.buttonEntries[i].setRelativePosition(new GuiRelativePos(this, 0, i * this.getEntryYSpacing()));
            }
        }
        for (i = 0; i < this.buttonEntries.length; ++i) {
            this.buttonEntries[i].hide();
            int index = i + this.scrollBar.getCurrentScroll();
            if (index >= this.entryCount) continue;
            this.buttonEntries[i].show();
            this.buttonEntries[i].setEnabled(this.callback.isEnabled(index));
            this.callback.updateEntry(index, this.buttonEntries[i]);
        }
        this.updatePositions();
    }

    @Override
    public void actionPerformed(GuiButton button) {
        int id = button.field_146127_k;
        if (id == 0) {
            this.reloadEntries();
        } else if (id >= 10 && id < 10 + this.entriesShown) {
            int index = id - 10 + this.scrollBar.getCurrentScroll();
            this.callback.onPressed(index);
            this.reloadEntries();
        }
    }

    protected int getEntryYSpacing() {
        return this.ySpacing;
    }

    public void setEntriesShown(int entries) {
        if (this.entriesShown != entries && this.buttonEntries != null) {
            this.updatePositionLogic = false;
            for (GuiComponent button : this.buttonEntries) {
                this.remove(button);
            }
            this.updatePositionLogic = true;
            this.buttonEntries = null;
        }
        this.entriesShown = entries;
        this.reloadEntries();
    }
}

