/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.explosive.blast;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.edit.IWorldChangeLayeredAction;
import com.builtbroken.mc.api.edit.IWorldEdit;
import com.builtbroken.mc.api.explosive.IExplosiveDamageable;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.api.tile.node.ITileNodeHost;
import com.builtbroken.mc.data.Direction;
import com.builtbroken.mc.framework.explosive.blast.Blast;
import com.builtbroken.mc.imp.transform.vector.BlockPos;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlastSimplePath<B extends BlastSimplePath>
extends Blast<B>
implements IWorldChangeLayeredAction {
    protected long lastUpdate = -1L;
    protected List<BlockPos> pathed_locations = new ArrayList<BlockPos>();
    public boolean recursive = false;
    public Queue<BlockPos> stack = new LinkedList<BlockPos>();
    protected int layers = 1;
    protected int blocksPerLayer = 1000;

    public BlastSimplePath(IExplosiveHandler handler) {
        super(handler);
    }

    public BlastSimplePath(IExplosiveHandler handler, World world, int x, int y, int z, int size) {
        super(handler, world, x, y, z, size);
    }

    @Override
    public void getEffectedBlocks(List<IWorldEdit> list) {
        BlockPos c = new BlockPos(this.xi(), this.yi(), this.zi());
        if (this.shouldPath(c)) {
            if (this.recursive) {
                this.pathNext(c, list);
            } else {
                this.pathEntire(c, list);
            }
        } else {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                BlockPos location = new BlockPos(this.xi() + dir.offsetX, this.yi() + dir.offsetY, this.zi() + dir.offsetZ);
                if (!this.shouldPath(location)) continue;
                if (this.recursive) {
                    this.pathNext(location, list);
                    continue;
                }
                this.pathEntire(location, list);
            }
        }
    }

    @Override
    public void getEffectedBlocks(List<IWorldEdit> list, int layer) {
        this.recursive = false;
        if (layer == 0) {
            this.getEffectedBlocks(list);
        } else {
            this.continuePathEntire(list, this.blocksPerLayer);
        }
    }

    @Override
    public B setYield(double size) {
        double prev = this.size;
        super.setYield(size);
        if (prev != size) {
            this.calculateLayers();
        }
        return (B)this;
    }

    public void calculateLayers() {
        double volume = Math.PI * this.size * this.size * this.size;
        int i = (int)(volume / (double)this.blocksPerLayer);
        this.layers = i > 0 ? i : 1;
    }

    @Override
    public int getLayers() {
        return this.layers;
    }

    @Override
    public boolean shouldContinueAction(int layer) {
        return !this.killExplosion && (layer == 0 || !this.stack.isEmpty());
    }

    public void pathEntire(BlockPos startNode, List<IWorldEdit> list) {
        this.pathEntire(startNode, list, this.blocksPerLayer);
    }

    public void pathEntire(BlockPos startNode, List<IWorldEdit> list, int count) {
        if (this.shouldPath(startNode)) {
            if (this.stack.isEmpty()) {
                IWorldEdit edit = this.getEditForLocation(startNode, null);
                if (edit != null) {
                    list.add(edit);
                }
                this.stack.offer(startNode);
                this.pathed_locations.add(startNode);
            }
            this.continuePathEntire(list, count);
        }
    }

    public void continuePathEntire(List<IWorldEdit> list, int count) {
        int currentCount = 0;
        boolean shouldExit = false;
        while (!this.stack.isEmpty() && !shouldExit && currentCount < count) {
            shouldExit = this.shouldKillAction();
            BlockPos currentNode = this.stack.poll();
            ++currentCount;
            for (Direction dir : Direction.DIRECTIONS) {
                BlockPos nextNode = new BlockPos((IPos3D)currentNode, dir);
                if (!this.shouldPathTo(currentNode, nextNode, dir)) continue;
                this.pathed_locations.add(nextNode);
                if (!this.shouldPath(nextNode)) continue;
                this.stack.offer(nextNode);
                IWorldEdit edit = this.getEditForLocation(nextNode, dir);
                if (edit == null || list.contains(edit) || !edit.hasChanged()) continue;
                list.add(edit);
            }
        }
    }

    public IWorldEdit getEditForLocation(BlockPos pos, Direction blastDirection) {
        float distance;
        float energy;
        float energyCost;
        TileEntity tileEntity = pos.getTileEntity(this.oldWorld);
        IExplosiveDamageable damageableTile = null;
        if (tileEntity instanceof IExplosiveDamageable) {
            damageableTile = (IExplosiveDamageable)tileEntity;
        } else if (tileEntity instanceof ITileNodeHost && ((ITileNodeHost)tileEntity).getTileNode() instanceof IExplosiveDamageable) {
            damageableTile = (IExplosiveDamageable)((Object)((ITileNodeHost)tileEntity).getTileNode());
        }
        if (damageableTile != null && (energyCost = damageableTile.getEnergyCostOfTile(this.explosiveHandler, this, blastDirection, energy = this.getEnergy(pos, distance = (float)this.blockCenter.distance((double)pos.xi() + 0.5, (double)pos.yi() + 0.5, (double)pos.zi() + 0.5)), distance)) > 0.0f) {
            return damageableTile.getBlockEditOnBlastImpact(this.explosiveHandler, this, blastDirection, energy, distance);
        }
        return this.changeBlock(pos);
    }

    public float getEnergy(BlockPos location, double distance) {
        return -1.0f;
    }

    public void pathNext(BlockPos node, List<IWorldEdit> list) {
        if (!this.shouldKillAction()) {
            if (!this.pathed_locations.contains(node)) {
                this.pathed_locations.add(node);
            }
            if (this.shouldPath(node)) {
                IWorldEdit edit = this.changeBlock(node);
                if (edit != null && !list.contains(edit) && edit.hasChanged()) {
                    list.add(edit);
                }
                for (Direction dir : Direction.DIRECTIONS) {
                    BlockPos next = new BlockPos((IPos3D)node, dir);
                    if (!this.shouldPathTo(node, next, dir)) continue;
                    this.pathNext(next, list);
                }
            }
        }
    }

    public abstract IWorldEdit changeBlock(BlockPos var1);

    public boolean shouldPath(BlockPos location) {
        double distance = this.blockCenter.distance((double)location.xi() + 0.5, (double)location.yi() + 0.5, (double)location.zi() + 0.5);
        return distance <= this.size;
    }

    public boolean shouldPathTo(BlockPos last, BlockPos next, Direction dir) {
        return this.shouldPathTo(last, next);
    }

    @Deprecated
    public boolean shouldPathTo(BlockPos last, BlockPos next) {
        return next.y() >= 0.0 && next.y() <= 255.0 && !this.pathed_locations.contains(next);
    }
}

