/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.generator;

import com.builtbroken.jlib.helpers.MathHelper;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.world.generator.OreGenerator;
import com.builtbroken.mc.lib.world.generator.OreGeneratorSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderEnd;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.ChunkProviderHell;
import net.minecraftforge.common.util.ForgeDirection;

public class OreGenReplace
extends OreGenerator {
    public final OreGeneratorSettings settings;
    public boolean ignoreSurface = false;
    public boolean ignoreNether = true;
    public boolean ignoreEnd = true;
    public int generatorType = 1;

    public OreGenReplace(Block block, int meta, OreGeneratorSettings settings, String harvestTool, int harvestLevel) {
        super(block, meta, harvestTool, harvestLevel);
        this.settings = settings;
    }

    @Override
    public void generate(World world, Random random, int varX, int varZ) {
        int placed;
        for (int blocksPlaced = 0; blocksPlaced < this.settings.amountPerChunk; blocksPlaced += placed) {
            int x = varX + random.nextInt(16);
            int z = varZ + random.nextInt(16);
            int y = random.nextInt(Math.max(this.settings.maxGenerateLevel - this.settings.minGenerateLevel, 0)) + this.settings.minGenerateLevel;
            placed = this.generateBranch(world, random, varX, varZ, x, y, z);
            if (placed > 0) continue;
            placed = this.settings.amountPerBranch;
        }
    }

    public int generateBranch(World world, Random rand, int chunkCornerX, int chunkCornerZ, int varX, int varY, int varZ) {
        int blocksPlaced = 0;
        if (this.generatorType == 0) {
            float angle = rand.nextFloat() * (float)Math.PI;
            double rxUpper = (float)(varX + 8) + net.minecraft.util.MathHelper.func_76126_a((float)angle) * (float)this.settings.amountPerBranch / 8.0f;
            double rxLower = (float)(varX + 8) - net.minecraft.util.MathHelper.func_76126_a((float)angle) * (float)this.settings.amountPerBranch / 8.0f;
            double rzUpper = (float)(varZ + 8) + net.minecraft.util.MathHelper.func_76134_b((float)angle) * (float)this.settings.amountPerBranch / 8.0f;
            double rzLower = (float)(varZ + 8) - net.minecraft.util.MathHelper.func_76134_b((float)angle) * (float)this.settings.amountPerBranch / 8.0f;
            double randomY = varY + rand.nextInt(3) - 2;
            double randomY2 = varY + rand.nextInt(3) - 2;
            for (int b = 0; b <= this.settings.amountPerBranch; ++b) {
                double var20 = rxUpper + (rxLower - rxUpper) * (double)b / (double)this.settings.amountPerBranch;
                double var22 = randomY + (randomY2 - randomY) * (double)b / (double)this.settings.amountPerBranch;
                double var24 = rzUpper + (rzLower - rzUpper) * (double)b / (double)this.settings.amountPerBranch;
                double var26 = rand.nextDouble() * (double)this.settings.amountPerBranch / 16.0;
                double var28 = (double)(net.minecraft.util.MathHelper.func_76126_a((float)((float)b * (float)Math.PI / (float)this.settings.amountPerBranch)) + 1.0f) * var26 + 1.0;
                double var30 = (double)(net.minecraft.util.MathHelper.func_76126_a((float)((float)b * (float)Math.PI / (float)this.settings.amountPerBranch)) + 1.0f) * var26 + 1.0;
                int startX = net.minecraft.util.MathHelper.func_76128_c((double)(var20 - var28 / 2.0));
                int startY = net.minecraft.util.MathHelper.func_76128_c((double)(var22 - var30 / 2.0));
                int startZ = net.minecraft.util.MathHelper.func_76128_c((double)(var24 - var28 / 2.0));
                int endX = net.minecraft.util.MathHelper.func_76128_c((double)(var20 + var28 / 2.0));
                int endY = net.minecraft.util.MathHelper.func_76128_c((double)(var22 + var30 / 2.0));
                int endZ = net.minecraft.util.MathHelper.func_76128_c((double)(var24 + var28 / 2.0));
                for (int px = startX; px <= endX; ++px) {
                    double deltaX = ((double)px + 0.5 - var20) / (var28 / 2.0);
                    if (!(deltaX * deltaX < 1.0)) continue;
                    for (int py = startY; py <= endY; ++py) {
                        double dy = ((double)py + 0.5 - var22) / (var30 / 2.0);
                        if (!(deltaX * deltaX + dy * dy < 1.0)) continue;
                        for (int pz = startZ; pz <= endZ; ++pz) {
                            double dz = ((double)pz + 0.5 - var24) / (var28 / 2.0);
                            Block block = world.func_147439_a(px, py, pz);
                            if (!(deltaX * deltaX + dy * dy + dz * dz < 1.0) || this.settings.replaceBlock != null && block != this.settings.replaceBlock || !world.func_147465_d(px, py, pz, this.oreBlock, this.oreMeta, 2)) continue;
                            ++blocksPlaced;
                        }
                    }
                }
            }
        } else if (this.generatorType == 1) {
            ArrayList<Pos> pathed = new ArrayList<Pos>();
            LinkedList<Pos> toPath = new LinkedList<Pos>();
            toPath.add(new Pos(varX, varY, varZ));
            ArrayList<ForgeDirection> directions = new ArrayList<ForgeDirection>();
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                directions.add(dir);
            }
            while (!toPath.isEmpty() && blocksPlaced < this.settings.amountPerBranch) {
                Pos next = (Pos)((Object)toPath.poll());
                pathed.add(next);
                Block block = next.getBlock((IBlockAccess)world);
                if ((this.settings.replaceBlock == null || block == this.settings.replaceBlock) && next.setBlock(world, this.oreBlock, this.oreMeta, 2)) {
                    ++blocksPlaced;
                }
                Collections.shuffle(directions);
                for (ForgeDirection direction : directions) {
                    Pos pos = (Pos)((Object)next.add(direction));
                    if (pathed.contains((Object)pos) || !world.field_73012_v.nextBoolean()) continue;
                    if (pos.isInsideMap()) {
                        boolean insideY;
                        boolean insideX = pos.xi() >= chunkCornerX && pos.xi() < chunkCornerX + 16;
                        boolean insideZ = pos.zi() >= chunkCornerZ && pos.zi() < chunkCornerZ + 16;
                        boolean bl = insideY = pos.yi() >= this.settings.minGenerateLevel && pos.yi() <= this.settings.maxGenerateLevel;
                        if (insideX && insideZ && insideY) {
                            block = pos.getBlock((IBlockAccess)world);
                            if (this.settings.replaceBlock == null || block == this.settings.replaceBlock) {
                                toPath.add(pos);
                            }
                        }
                    }
                    if (toPath.contains((Object)pos)) continue;
                    pathed.add(pos);
                }
            }
        } else if (this.generatorType == 2) {
            int n = 1 + MathHelper.rand.nextInt(Math.max(1, this.settings.amountPerBranch - 1));
        }
        return blocksPlaced;
    }

    @Override
    public boolean isOreGeneratedInWorld(World world, IChunkProvider chunkGenerator) {
        if (this.ignoreSurface && chunkGenerator instanceof ChunkProviderGenerate) {
            return false;
        }
        if (this.ignoreNether && chunkGenerator instanceof ChunkProviderHell) {
            return false;
        }
        return !this.ignoreEnd || !(chunkGenerator instanceof ChunkProviderEnd);
    }
}

