/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.json.processors;

import com.builtbroken.jlib.debug.DebugPrinter;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.json.JsonContentLoader;
import com.builtbroken.mc.framework.json.conversion.data.mc.JsonConverterItem;
import com.builtbroken.mc.framework.json.imp.IJsonGenObject;
import com.builtbroken.mc.framework.json.imp.IJsonProcessor;
import com.builtbroken.mc.framework.json.loading.JsonProcessorInjectionMap;
import com.builtbroken.mc.framework.json.struct.JsonConditional;
import com.builtbroken.mc.framework.json.struct.JsonForLoop;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;

public abstract class JsonProcessor<D extends IJsonGenObject>
implements IJsonProcessor {
    protected JsonProcessorInjectionMap keyHandler;
    protected DebugPrinter debugPrinter;

    public JsonProcessor() {
        this.debugPrinter = JsonContentLoader.INSTANCE != null ? JsonContentLoader.INSTANCE.debug : new DebugPrinter(LogManager.getLogger());
    }

    public JsonProcessor(Class<D> clazz) {
        this();
        this.keyHandler = new JsonProcessorInjectionMap(clazz);
    }

    @Override
    public boolean canProcess(String key, JsonElement element) {
        return key.equalsIgnoreCase(this.getJsonKey());
    }

    @Override
    public boolean process(JsonElement element, List<IJsonGenObject> objects) {
        this.handle(null, element, objects);
        return true;
    }

    protected void handle(Object out, JsonElement element, List<IJsonGenObject> objects) {
        JsonObject jsonObject;
        if (element.isJsonObject() && JsonForLoop.hasLoops(jsonObject = element.getAsJsonObject())) {
            JsonForLoop.handleLoops(jsonObject, o -> {
                D data = this.process(out, (JsonElement)o);
                if (data != null) {
                    objects.add((IJsonGenObject)data);
                }
            });
            return;
        }
        D data = this.process(out, element);
        if (data != null) {
            objects.add((IJsonGenObject)data);
        }
    }

    protected D process(Object out, JsonElement element) {
        return this.process(element);
    }

    protected D process(JsonElement element) {
        return null;
    }

    protected void processAdditionalKeys(D objectToInject, JsonObject jsonData) {
        this.processAdditionalKeys(objectToInject, jsonData, null);
    }

    protected void processAdditionalKeys(D objectToInject, JsonObject jsonData, List<String> keysToIgnore) {
        try {
            for (Map.Entry entry : jsonData.entrySet()) {
                if (keysToIgnore != null && keysToIgnore.contains(entry.getKey()) || !this.keyHandler.handle(objectToInject, ((String)entry.getKey()).toLowerCase(), entry.getValue()) || !Engine.runningAsDev) continue;
                this.debugPrinter.log("Injected Key: " + (String)entry.getKey());
            }
            this.keyHandler.enforceRequired(objectToInject);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void ensureValuesExist(JsonObject object, String ... values) {
        for (String value : values) {
            if (object.has(value)) continue;
            throw new IllegalArgumentException("File is missing '" + value + "' value from inside '" + object + "'");
        }
    }

    @Override
    public boolean shouldLoad(JsonElement object) {
        if (object instanceof JsonObject && ((JsonObject)object).has("loadCondition")) {
            return JsonConditional.isConditionalTrue(((JsonObject)object).get("loadCondition"), this);
        }
        return true;
    }

    public static Object getItemFromJson(JsonElement element) {
        if (element.isJsonObject()) {
            return JsonConverterItem.fromJson(element.getAsJsonObject());
        }
        if (element.isJsonPrimitive()) {
            return element.getAsString();
        }
        throw new RuntimeException("Could not convert json element into item entry >> '" + element + "'");
    }
}

