/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.json.override;

import com.builtbroken.mc.core.registry.implement.ILoadComplete;
import com.builtbroken.mc.framework.json.JsonContentLoader;
import com.builtbroken.mc.framework.json.imp.IJsonGenObject;
import com.builtbroken.mc.framework.json.imp.IJsonProcessor;
import com.builtbroken.mc.framework.json.override.IModifableJson;
import com.builtbroken.mc.framework.json.processors.JsonGenData;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;

public class JsonOverrideData
extends JsonGenData
implements ILoadComplete {
    private String contentID;
    private String processorID;
    private String action;
    private JsonElement data;

    public JsonOverrideData(IJsonProcessor processor, String contentID, String processorID, String action, JsonElement data) {
        super(processor);
        this.contentID = contentID.toLowerCase();
        this.processorID = processorID.toLowerCase();
        this.action = action.toLowerCase();
        this.data = data;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onLoadCompleted() {
        IJsonProcessor processor = JsonContentLoader.INSTANCE.processors.get(this.processorID);
        if (processor == null) throw new IllegalArgumentException("Unknown processor[" + this.processorID + "] for override data");
        if (!(processor instanceof IModifableJson)) throw new IllegalArgumentException("Processor[" + this.processorID + "] does not support modifying json data");
        if (JsonContentLoader.INSTANCE.generatedObjects.get(this.processorID) == null) throw new IllegalArgumentException("No generated objects listed for processor[" + this.processorID + "] to find content by ID[" + this.contentID + "]");
        IJsonGenObject genObject = null;
        for (IJsonGenObject obj : JsonContentLoader.INSTANCE.generatedObjects.get(this.processorID)) {
            if (obj == null || !this.contentID.equalsIgnoreCase(obj.getContentID())) continue;
            genObject = obj;
            break;
        }
        if (genObject == null) throw new IllegalArgumentException("Could not find content by ID[" + this.contentID + "] in list from processor[" + this.processorID + "]");
        if ("add".equals(this.action)) {
            if (!(this.data instanceof JsonObject)) throw new IllegalArgumentException("Data for add action must used a json object for providing additions");
            for (Map.Entry entry : ((JsonObject)this.data).entrySet()) {
                ((IModifableJson)((Object)processor)).addData((String)entry.getKey(), (JsonElement)entry.getValue(), genObject);
            }
            return;
        } else {
            if ("remove".equals(this.action)) {
                if (this.data instanceof JsonArray) return;
                throw new IllegalArgumentException("Data for remove action must used a json array for providing additions");
            }
            if (!"replace".equals(this.action)) throw new IllegalArgumentException("Unknown action type[" + this.action + "] for override data");
            if (!(this.data instanceof JsonObject)) throw new IllegalArgumentException("Data for replace action must used a json object for providing additions");
            for (Map.Entry entry : ((JsonObject)this.data).entrySet()) {
                ((IModifableJson)((Object)processor)).replaceData((String)entry.getKey(), (JsonElement)entry.getValue(), genObject);
            }
        }
    }

    @Override
    public String getContentID() {
        return null;
    }

    @Override
    public String getUniqueID() {
        return null;
    }
}

