/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.json.conversion.structures.list;

import com.builtbroken.mc.framework.json.conversion.JsonConverter;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JsonConverterList
extends JsonConverter<List> {
    public JsonConverterList() {
        super("list", "list.array");
    }

    @Override
    public List convert(JsonElement element, String[] args) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (args.length != 1) {
            throw new RuntimeException("JsonConverterList: arguments needs to contain at least 1 value containing of conversion type in order to function");
        }
        if (element.isJsonArray()) {
            String type = args[0];
            for (JsonElement e : element.getAsJsonArray()) {
                Object object = JsonConverterList.convertElement(type, e, new String[0]);
                if (object == null) {
                    throw new RuntimeException("JsonConverterList: failed to convert data '" + e + "' to type '" + type + "'");
                }
                if (object instanceof Collection) {
                    list.addAll((Collection)object);
                    continue;
                }
                list.add(object);
            }
        } else {
            throw new RuntimeException("JsonConverterHashMap: json element needs to be an array in order to convert to hash map");
        }
        return list;
    }
}

