/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.json;

import com.builtbroken.jlib.debug.DebugPrinter;
import com.builtbroken.jlib.lang.StringHelpers;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.References;
import com.builtbroken.mc.core.registry.implement.ILoadComplete;
import com.builtbroken.mc.core.registry.implement.IPostInit;
import com.builtbroken.mc.core.registry.implement.IRecipeContainer;
import com.builtbroken.mc.core.registry.implement.IRegistryInit;
import com.builtbroken.mc.framework.json.IJsonGenMod;
import com.builtbroken.mc.framework.json.event.JsonEntryCreationEvent;
import com.builtbroken.mc.framework.json.event.JsonProcessorRegistryEvent;
import com.builtbroken.mc.framework.json.imp.IJsonGenObject;
import com.builtbroken.mc.framework.json.imp.IJsonProcessor;
import com.builtbroken.mc.framework.json.imp.JsonLoadPhase;
import com.builtbroken.mc.framework.json.loading.JsonEntry;
import com.builtbroken.mc.framework.json.loading.JsonLoader;
import com.builtbroken.mc.framework.json.loading.ProcessorKeySorter;
import com.builtbroken.mc.framework.mod.loadable.AbstractLoadable;
import com.builtbroken.mc.framework.mod.loadable.ILoadable;
import com.google.gson.JsonElement;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Stream;
import javax.swing.JOptionPane;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.lwjgl.opengl.Display;

public final class JsonContentLoader
extends AbstractLoadable {
    public static JsonContentLoader INSTANCE = new JsonContentLoader();
    public final List<URL> classPathResources = new ArrayList<URL>();
    public final List<File> externalFiles = new ArrayList<File>();
    public final List<File> externalJarFiles = new ArrayList<File>();
    public final List<String> extensionsToLoad = new ArrayList<String>();
    public final HashMap<String, IJsonProcessor> processors = new HashMap();
    public final HashMap<String, List<JsonEntry>> jsonEntries = new HashMap();
    public final HashMap<String, List<IJsonGenObject>> generatedObjects = new HashMap();
    public boolean ignoreFileLoading = false;
    public File externalContentFolder;
    public DebugPrinter debug;
    protected JsonLoadPhase currentPhase = JsonLoadPhase.HANDLERS;

    public JsonContentLoader() {
        this.debug = new DebugPrinter(LogManager.getLogger((String)"JsonContentLoader"));
        this.extensionsToLoad.add("json");
    }

    public void add(IJsonProcessor processor) {
        this.debug.start("Added Processor< " + processor.getJsonKey() + ", " + processor + " >");
        this.add(processor.getJsonKey(), processor);
        MinecraftForge.EVENT_BUS.post((Event)new JsonProcessorRegistryEvent(this, this.currentPhase, processor));
        if (processor instanceof ILoadable) {
            Engine.loaderInstance.getModuleLoader().applyModule((ILoadable)((Object)processor));
            this.debug.log("-is loadable");
        }
        this.debug.end();
    }

    protected void add(String key, IJsonProcessor processor) {
        this.processors.put(processor.getJsonKey(), processor);
    }

    public IJsonProcessor get(String key) {
        return this.processors.get(key);
    }

    @Override
    public void preInit() {
        this.debug.start("Phase: Pre-Init");
        this.debug.start("Validating file paths");
        this.externalContentFolder = new File(References.BBM_CONFIG_FOLDER, "json");
        this.validateFilePaths();
        this.debug.end("Done...");
        this.debug.start("Registering mod processors");
        for (ModContainer container : Loader.instance().getModList()) {
            Object mod = container.getMod();
            if (!(mod instanceof IJsonGenMod)) continue;
            try {
                this.debug.log("Mod: " + container.getName() + "  " + container.getDisplayVersion());
                ((IJsonGenMod)mod).loadJsonContentHandlers();
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error while loading JSON content handlers from " + ((IJsonGenMod)mod).getDomain(), e);
            }
        }
        this.triggerPhase(JsonLoadPhase.HANDLERS);
        this.debug.end("Done...");
        this.debug.start("Loading files");
        if (!this.ignoreFileLoading) {
            this.loadResources();
        } else {
            this.debug.log("Resource loading is disable, this might be due to testing suits or other reasons");
            this.debug.log("JUnit: " + Engine.isJUnitTest());
        }
        this.debug.end("Done...");
        this.debug.start("Process Run[1]");
        this.processEntries();
        this.debug.end("Done... " + this.jsonEntries.size() + " entries left");
        this.triggerPhase(JsonLoadPhase.BLOCKS);
        this.triggerPhase(JsonLoadPhase.ITEMS);
        this.triggerPhase(JsonLoadPhase.CONTENT);
        this.triggerPhase(JsonLoadPhase.ENTITIES);
        this.triggerPhase(JsonLoadPhase.LOAD_PHASE_ONE);
        this.debug.end("Done...");
    }

    public void triggerPhase(JsonLoadPhase phase) {
        this.currentPhase = phase;
        for (List<IJsonGenObject> list : this.generatedObjects.values()) {
            for (IJsonGenObject object : list) {
                object.onPhase(phase);
            }
        }
    }

    @Override
    public void init() {
        this.debug.start("Phase: Init");
        this.debug.start("Process Run[2]");
        this.processEntries();
        this.debug.end("Done... " + this.jsonEntries.size() + " entries left");
        this.triggerPhase(JsonLoadPhase.RECIPES);
        this.triggerPhase(JsonLoadPhase.LOAD_PHASE_TWO);
        this.debug.end("Done...");
    }

    @Override
    public void postInit() {
        this.debug.start("Phase: Post-Init");
        this.debug.start("Process Run[3]");
        this.processEntries();
        this.debug.end("Done...");
        this.debug.start("Doing post handling for generated objects");
        List<String> sortingProcessorList = this.getSortedProcessorList();
        for (String processorKey : sortingProcessorList) {
            this.handlePostCalls(this.generatedObjects.get(processorKey));
        }
        this.debug.end("Done... " + this.jsonEntries.size() + " entries left");
        this.triggerPhase(JsonLoadPhase.LOAD_PHASE_THREE);
        this.debug.end("Done...");
    }

    @Override
    public void loadComplete() {
        this.debug.start("Phase: Load-Complete");
        List<String> sortingProcessorList = this.getSortedProcessorList();
        for (String string : sortingProcessorList) {
            if (this.generatedObjects.get(string) == null || this.generatedObjects.get(string).isEmpty()) continue;
            for (IJsonGenObject obj : this.generatedObjects.get(string)) {
                if (!(obj instanceof ILoadComplete)) continue;
                ((ILoadComplete)((Object)obj)).onLoadCompleted();
            }
        }
        this.debug.log("Clearing data");
        if (this.jsonEntries.size() > 0 && Engine.runningAsDev && !GraphicsEnvironment.isHeadless()) {
            int n;
            boolean processorExists = false;
            Engine.logger().info("Failed to process all JSON entries. This is most likely a bug if the count is high.");
            for (Map.Entry<String, List<JsonEntry>> entry : this.jsonEntries.entrySet()) {
                boolean exists;
                boolean bl = exists = this.get(entry.getKey()) != null;
                if (exists) {
                    processorExists = exists;
                }
                Engine.logger().info("\tProcessor: " + entry.getKey() + " has register processor '" + exists + "'");
                for (JsonEntry entry2 : entry.getValue()) {
                    Engine.logger().info("\t\tEntry: " + entry2 + "\n");
                }
            }
            if (processorExists && (n = JOptionPane.showConfirmDialog(Display.getParent(), "Not all JSON entries have been processed. \n JsonEntries left = " + this.jsonEntries.size() + "\n Do you want to continue loading?", "JsonContentLoader Error", 0, 0)) != 0) {
                FMLCommonHandler.instance().exitJava(-1, false);
            }
        }
        this.triggerPhase(JsonLoadPhase.COMPLETED);
        this.clear();
        this.debug.end("Done...");
    }

    public void claimContent(IJsonGenMod mod) {
        for (List<IJsonGenObject> list : this.generatedObjects.values()) {
            if (list == null || list.isEmpty()) continue;
            for (IJsonGenObject object : list) {
                if (object.getMod() == null || !object.getMod().equals(mod.getDomain())) continue;
                object.register(mod, mod.getJsonContentManager());
            }
        }
    }

    public void process(String processorKey) {
        if (this.jsonEntries.containsKey(processorKey)) {
            List<JsonEntry> entries = this.jsonEntries.get(processorKey);
            if (entries != null) {
                this.debug.log("Entries: " + entries);
                Iterator<JsonEntry> it = entries.iterator();
                while (it.hasNext()) {
                    JsonEntry entry = it.next();
                    this.debug.log("Entry: " + entry);
                    try {
                        ArrayList<IJsonGenObject> objects = new ArrayList<IJsonGenObject>();
                        boolean handled = this.process(entry.jsonKey, entry.element, objects);
                        for (IJsonGenObject genObject : objects) {
                            List<IJsonGenObject> list;
                            if (genObject == null) continue;
                            if (entry.author != null && !entry.author.isEmpty()) {
                                genObject.setAuthor(entry.author);
                            }
                            if ((list = this.generatedObjects.get(processorKey)) == null) {
                                list = new ArrayList<IJsonGenObject>();
                            }
                            list.add(genObject);
                            this.generatedObjects.put(processorKey, list);
                            genObject.validate();
                            genObject.onCreated();
                            if (genObject instanceof IRegistryInit) {
                                ((IRegistryInit)((Object)genObject)).onRegistered();
                            }
                            JsonEntryCreationEvent entryCreationEvent = new JsonEntryCreationEvent(this, this.currentPhase, genObject.getMod(), genObject.getUniqueID(), genObject.getContentID(), genObject);
                            MinecraftForge.EVENT_BUS.post((Event)entryCreationEvent);
                        }
                        if (!handled) continue;
                        it.remove();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to process entry from file " + entry.fileReadFrom + ". Make corrections to the file or contact the file's creator for the issue to be fixed.\n  Entry = " + entry, e);
                    }
                }
            }
            if (entries.size() <= 0) {
                this.jsonEntries.remove(processorKey);
            } else {
                this.jsonEntries.put(processorKey, entries);
            }
        } else {
            this.debug.log("No entries for key");
        }
    }

    protected void processEntries() {
        if (this.jsonEntries.size() > 0) {
            List<String> sortingProcessorList = this.getSortedProcessorList();
            for (String processorKey : sortingProcessorList) {
                this.debug.start("processEntries()", "Handling: " + processorKey, Engine.runningAsDev);
                this.process(processorKey);
                this.debug.end();
            }
        }
    }

    protected List<String> getSortedProcessorList() {
        ArrayList<String> processorKeys = new ArrayList<String>();
        for (IJsonProcessor processor : this.processors.values()) {
            String jsonKey = processor.getJsonKey();
            String loadOrder = processor.getLoadOrder();
            if (loadOrder != null && !loadOrder.isEmpty()) {
                jsonKey = jsonKey + "@" + loadOrder;
            }
            processorKeys.add(jsonKey);
        }
        return this.sortSortingValues(processorKeys);
    }

    public void validateFilePaths() {
        if (!this.externalContentFolder.exists()) {
            this.externalContentFolder.mkdirs();
        }
    }

    public void loadResources() {
        this.debug.start("Loading json resources");
        this.debug.start("\tScanning mod packages for json data");
        for (ModContainer container : Loader.instance().getModList()) {
            File file = container.getSource();
            this.debug.log("Mod: " + container.getName() + "  " + container.getDisplayVersion());
            this.debug.log("File: " + file);
            Object mod = container.getMod();
            if (mod == null) continue;
            this.loadResourcesFromPackage(mod.getClass(), "/content/" + container.getModId() + "/");
        }
        this.debug.end();
        this.debug.start("Scanning for external files");
        this.loadResourcesFromFolder(this.externalContentFolder);
        this.debug.end();
        this.debug.start("Loading external resources");
        for (File file : this.externalFiles) {
            try {
                this.debug.log("Loading resource: " + file);
                JsonLoader.loadJsonFile(file, this.jsonEntries);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load external resource " + file, e);
            }
        }
        this.debug.end();
        this.debug.start("Loading class path resources");
        for (URL resource : this.classPathResources) {
            try {
                this.debug.log("Loading resource: " + resource);
                JsonLoader.loadJsonFileFromResources(resource, this.jsonEntries);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load classpath resource " + resource, e);
            }
        }
        this.debug.end();
        this.debug.end("Done....");
    }

    public List<String> sortSortingValues(List<String> values) {
        long start = System.nanoTime();
        this.debug.start("ProcessorKeySorter", "Sorting processor keys", Engine.runningAsDev);
        Collections.sort(values, new ProcessorKeySorter());
        LinkedList<String> sortedValues = new LinkedList<String>();
        while (!values.isEmpty()) {
            JsonContentLoader.sortSortingValues(values, sortedValues);
            if (values.isEmpty()) continue;
            Iterator<String> it = values.iterator();
            while (it.hasNext()) {
                String entry = it.next();
                this.debug.log("E: " + entry);
                if (entry.contains("@")) {
                    String[] split = entry.split("@");
                    String name = entry.split("@")[0];
                    this.debug.log("\tName: " + name);
                    if (split[1].contains(":")) {
                        split = split[1].split(":");
                        boolean found = false;
                        this.debug.log("\t" + split[0] + "  " + split[1]);
                        this.debug.start("Check A");
                        for (String v : values) {
                            this.debug.log("" + v + "  " + v.startsWith(split[1]));
                            if (v.equals(entry) || !v.startsWith(split[1])) continue;
                            this.debug.log("\tFound entry");
                            found = true;
                            break;
                        }
                        this.debug.end();
                        if (!found) {
                            this.debug.start("Check B");
                            for (String v : sortedValues) {
                                this.debug.log("" + v + "  " + v.equals(split[1]));
                                if (v.equals(entry) || !v.equals(split[1])) continue;
                                this.debug.log("\tB:" + found);
                                found = true;
                                break;
                            }
                            this.debug.end();
                        }
                        if (found) continue;
                        Engine.logger().error("Bad sorting value for " + entry + " could not find category for " + split[1]);
                        sortedValues.add(name);
                        it.remove();
                        continue;
                    }
                    Engine.logger().error("Bad sorting value for " + entry + " has no valid sorting data");
                    sortedValues.add(name);
                    it.remove();
                    continue;
                }
                sortedValues.add(entry);
                it.remove();
            }
        }
        this.debug.end("Done.... " + StringHelpers.formatTimeDifference((long)start, (long)System.nanoTime()));
        return sortedValues;
    }

    public static void sortSortingValues(List<String> sortingValues, List<String> sortedValues) {
        Iterator<String> it = sortingValues.iterator();
        while (it.hasNext()) {
            String entry = it.next();
            if (entry.contains("@")) {
                String[] split = entry.split("@");
                String name = split[0];
                String sortValue = split[1];
                if (sortValue.contains(":")) {
                    split = sortValue.split(":");
                    String prefix = split[0];
                    String cat = split[1];
                    boolean catFound = false;
                    ListIterator<String> sortedIt = sortedValues.listIterator();
                    while (sortedIt.hasNext()) {
                        String v = sortedIt.next();
                        if (!v.equalsIgnoreCase(cat)) continue;
                        catFound = true;
                        if (prefix.equalsIgnoreCase("after")) {
                            sortedIt.add(name);
                            break;
                        }
                        if (prefix.equalsIgnoreCase("before")) {
                            sortedIt.previous();
                            sortedIt.add(name);
                            break;
                        }
                        Engine.logger().error("Bad sorting value for " + entry + " we can only read 'after' and 'before'");
                        sortedValues.add(name);
                        it.remove();
                        break;
                    }
                    if (!catFound) continue;
                    it.remove();
                    continue;
                }
                sortedValues.add(name);
                it.remove();
                continue;
            }
            sortedValues.add(entry);
            it.remove();
        }
    }

    public boolean process(String key, JsonElement element, List<IJsonGenObject> objects) {
        IJsonProcessor processor = this.get(key);
        if (processor != null && processor.canProcess(key, element) && processor.shouldLoad(element)) {
            return processor.process(element, objects);
        }
        return false;
    }

    public void loadResourcesFromFolder(File folder) {
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                this.loadResourcesFromFolder(folder);
                continue;
            }
            String extension = file.getName().substring(file.getName().lastIndexOf(".") + 1, file.getName().length());
            if (extension.equalsIgnoreCase("jar")) {
                this.externalJarFiles.add(file);
                continue;
            }
            if (!this.extensionsToLoad.contains(extension)) continue;
            this.externalFiles.add(file);
        }
    }

    public void loadResourcesFromPackage(Class clazz, String folder) {
        try {
            URL url = clazz.getClassLoader().getResource(folder);
            if (url == null) {
                url = clazz.getResource(folder);
            }
            if (url != null) {
                URI uri = url.toURI();
                this.loadResourcesFromPackage(uri, folder);
            } else {
                this.debug.error("Could not locate folder[ " + folder + " ]");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load resources from class path.  Class='" + clazz + "' folder= '" + folder + "'", e);
        }
    }

    public void loadResourcesFromPackage(URI uri, String folder) throws Exception {
        block15: {
            try {
                if ("jar".equals(uri.getScheme())) {
                    this.debug.error("Jar detected, using secondary method to load resources.");
                    URI jar = new URI(uri.getScheme(), uri.getSchemeSpecificPart().replace("%20", " "), null);
                    HashMap<String, String> env = new HashMap<String, String>();
                    env.put("create", "true");
                    try (FileSystem fs = FileSystems.newFileSystem(jar, env, this.getClass().getClassLoader());){
                        this.walkPaths(fs.getPath(folder, new String[0]));
                        break block15;
                    }
                }
                this.walkPaths(Paths.get(uri));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to walk files from URI = " + uri, e);
            }
        }
    }

    private void walkPaths(Path filePath) throws IOException {
        this.debug.start("Loading files from " + filePath);
        Stream<Path> walk = Files.walk(filePath, 100, new FileVisitOption[0]);
        Iterator it = walk.iterator();
        while (it.hasNext()) {
            String extension;
            Path nextPath = (Path)it.next();
            String name = nextPath.getFileName().toString();
            if (name.lastIndexOf(".") <= 1 || !this.extensionsToLoad.contains(extension = name.substring(name.lastIndexOf(".") + 1, name.length()))) continue;
            this.debug.log("Found " + name);
            JsonLoader.loadJson(nextPath.toAbsolutePath().toString(), Files.newBufferedReader(nextPath), this.jsonEntries);
        }
        this.debug.end("Done...");
    }

    private FileSystem getFileSystem(URI uri) throws IOException {
        try {
            return FileSystems.getFileSystem(uri);
        }
        catch (FileSystemNotFoundException e) {
            return FileSystems.newFileSystem(uri, Collections.emptyMap());
        }
    }

    public void handlePostCalls(List<IJsonGenObject> generatedObjects) {
        if (generatedObjects != null && !generatedObjects.isEmpty()) {
            for (IJsonGenObject obj : generatedObjects) {
                this.debug.start("Handling: " + obj);
                if (obj instanceof IPostInit) {
                    ((IPostInit)((Object)obj)).onPostInit();
                }
                if (obj instanceof IRecipeContainer) {
                    ArrayList<IRecipe> recipes = new ArrayList<IRecipe>();
                    ((IRecipeContainer)((Object)obj)).genRecipes(recipes);
                    if (recipes.size() > 0) {
                        this.debug.start("Adding recipes from gen object:");
                        for (IRecipe recipe : recipes) {
                            if (recipe != null) {
                                if (recipe.func_77571_b() != null) {
                                    GameRegistry.addRecipe((IRecipe)recipe);
                                    continue;
                                }
                                this.debug.log("Null recipe output detected");
                                continue;
                            }
                            this.debug.log("Null recipe detected");
                        }
                        this.debug.end();
                    }
                }
                this.debug.end();
            }
        }
    }

    public void clear() {
        if (!Engine.runningAsDev) {
            this.debug.log("Clearing cached data to same RAM");
            this.externalFiles.clear();
            this.externalJarFiles.clear();
            this.classPathResources.clear();
            this.jsonEntries.clear();
        } else {
            this.debug.log("Not clearing cache in order to allow debugging of data");
        }
    }
}

