/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.item;

import com.builtbroken.mc.api.items.listeners.IItemEventListener;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.item.ItemBase;
import com.builtbroken.mc.framework.item.ItemNodeSubType;
import com.builtbroken.mc.framework.json.imp.IJsonKeyDataProvider;
import com.builtbroken.mc.framework.json.loading.JsonProcessorData;
import com.builtbroken.mc.framework.json.struct.JsonConditional;
import com.builtbroken.mc.framework.json.struct.JsonForLoop;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ItemNode
implements IItemEventListener,
IJsonKeyDataProvider {
    private static final List<String> empty_list = new ArrayList(){

        @Override
        public boolean add(Object s) {
            return false;
        }
    };
    public final String owner;
    public final String id;
    public ItemBase item;
    private boolean hasSubTypes = false;
    private int maxStackSize = 64;
    private String unlocalizedName;
    private String tabToDisplayOn;
    public HashMap<Integer, ItemNodeSubType> subTypeHashMap = new HashMap();
    public HashMap<String, ItemNodeSubType> nameToSubType = new HashMap();

    public ItemNode(String owner, String id) {
        this.owner = owner;
        this.id = id;
    }

    public boolean hasSubTypes() {
        return this.hasSubTypes;
    }

    @JsonProcessorData(value={"hasSubTypes"})
    public void setHasSubTypes(boolean hasSubTypes) {
        this.hasSubTypes = hasSubTypes;
        this.item.func_77627_a(hasSubTypes);
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    @JsonProcessorData(value={"maxStackSize"}, type="int")
    public void setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
    }

    @Override
    public List<String> getListenerKeys() {
        return empty_list;
    }

    @JsonProcessorData(value={"name"})
    public void setUnlocalizedName(String name) {
        this.unlocalizedName = name;
        this.item.func_77655_b(this.owner + ":" + name);
    }

    public String getTabToDisplayOn() {
        return this.tabToDisplayOn;
    }

    @JsonProcessorData(value={"creativeTab"})
    public void setTabToDisplayOn(String tabToDisplayOn) {
        this.tabToDisplayOn = tabToDisplayOn;
    }

    @JsonProcessorData(value={"subTypes"})
    public void setSubTypes(JsonElement data) {
        if (data.isJsonArray()) {
            for (JsonElement element : data.getAsJsonArray()) {
                if (element.isJsonObject()) {
                    JsonObject itemData = element.getAsJsonObject();
                    if (JsonForLoop.hasLoops(itemData)) {
                        JsonForLoop.handleLoops(itemData, e -> this.createItemSubType((JsonObject)e));
                        continue;
                    }
                    this.createItemSubType(itemData);
                    continue;
                }
                throw new IllegalArgumentException("ItemNode#setSubTypes(data) >> process subtypes >> sub type entries must be a JsonObject, " + element);
            }
        } else {
            throw new IllegalArgumentException("ItemNode#setSubTypes(data) requires that the input from JSON be a json array matching '\"subType\":[{values1}, {value2}]");
        }
    }

    protected void createItemSubType(JsonObject itemData) {
        ItemNodeSubType subType = new ItemNodeSubType(this.item, this, itemData);
        if (itemData.has("loadCondition") && !JsonConditional.isConditionalTrue(itemData.get("loadCondition"), this)) {
            return;
        }
        if (this.subTypeHashMap.containsKey(subType.index)) {
            throw new IllegalArgumentException("ItemNode#setSubTypes(data) >> process subtypes >> duplicate index used for " + subType + " and " + this.subTypeHashMap.get(subType.index));
        }
        if (this.nameToSubType.containsKey(subType.id)) {
            throw new IllegalArgumentException("ItemNode#setSubTypes(data) >> process subtypes >> duplicate id used for " + subType + " and " + this.nameToSubType.get(subType.id));
        }
        this.subTypeHashMap.put(subType.index, subType);
        this.nameToSubType.put(subType.id, subType);
    }

    public void readPacketData(ByteBuf buf, EntityPlayer player, ItemStack stack) {
        if (Engine.runningAsDev) {
            throw new RuntimeException("Received packet on item without being coded to handle packets.");
        }
    }

    public String getRenderContentID(int meta) {
        return this.id;
    }

    @Override
    public Object getJsonKeyData(String key) {
        if (key.equalsIgnoreCase("id")) {
            return this.id;
        }
        return null;
    }
}

