/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.explosive.handler;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.explosive.ExplosiveRegistry;
import com.builtbroken.mc.framework.explosive.handler.ExplosiveHandler;
import com.builtbroken.mc.framework.json.imp.IJsonProcessor;
import com.builtbroken.mc.framework.json.loading.JsonProcessorData;
import com.builtbroken.mc.framework.json.processors.JsonGenData;
import java.lang.reflect.InvocationTargetException;

public class ExplosiveData
extends JsonGenData {
    @JsonProcessorData(value={"id"}, required=true)
    public String id;
    @JsonProcessorData(value={"name"}, required=true)
    public String translationKey;
    @JsonProcessorData(value={"handler"}, required=true)
    public String blastHandlerClass;
    @JsonProcessorData(value={"powerMultiplier"}, type="int")
    public int multiplier = 1;

    public ExplosiveData(IJsonProcessor processor) {
        super(processor);
    }

    @Override
    public void onCreated() {
        try {
            Class<?> clazz = Class.forName(this.blastHandlerClass);
            if (ExplosiveHandler.class.isAssignableFrom(clazz)) {
                ExplosiveHandler handler = (ExplosiveHandler)clazz.getConstructor(ExplosiveData.class).newInstance(this);
                if (!ExplosiveRegistry.registerExplosive(this.modID, this.id, handler)) {
                    throw new RuntimeException("ExplosiveData#register() - failed to register explosive '" + this.id + "' with handler '" + this.blastHandlerClass + "'");
                }
            } else {
                throw new RuntimeException("ExplosiveData#register() - class for '" + this.blastHandlerClass + "' is not an sub class of ExplosiveHandler.class");
            }
            Engine.logger().info("ExplosiveData: Registered explosive '" + this.id + "' with handler '" + this.blastHandlerClass + "' successfully");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("ExplosiveData#register() - failed to locate class for '" + this.blastHandlerClass + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("ExplosiveData#register() - failed to access constructor for '" + this.blastHandlerClass + "'", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("ExplosiveData#register() - failed to instantiate constructor for '" + this.blastHandlerClass + "'", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("ExplosiveData#register() - failed to locate constructor for '" + this.blastHandlerClass + "'", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("ExplosiveData#register() - failed to invoke constructor for '" + this.blastHandlerClass + "'", e);
        }
    }

    @Override
    public String getContentID() {
        return this.id;
    }

    @Override
    public String getUniqueID() {
        return this.id;
    }
}

