/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.explosive;

import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.api.items.explosives.IExplosiveItem;
import com.builtbroken.mc.framework.explosive.ExplosiveRegistry;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ExplosiveItemUtility {
    public static final String EXPLOSIVE_SAVE = "explosiveString";
    public static final String SIZE_SAVE = "explosiveSize";

    public static void addInformation(ItemStack stack, EntityPlayer player, List lines, boolean b) {
        if (stack != null) {
            if (stack.func_77973_b() instanceof IExplosiveItem) {
                ExplosiveItemUtility.addInformation(stack, ((IExplosiveItem)stack.func_77973_b()).getExplosive(stack), player, lines, b);
            } else {
                lines.add(LanguageUtility.getLocalName("error.stack.invalid.IExplosiveItem"));
            }
        } else {
            lines.add(LanguageUtility.getLocalName("error.null_stack"));
        }
    }

    public static void addInformation(ItemStack stack, IExplosiveHandler ex, EntityPlayer player, List lines, boolean b) {
        if (stack != null) {
            if (ex != null) {
                ArrayList<String> l = new ArrayList<String>();
                ex.addInfoToItem(player, stack, l);
                for (String s : l) {
                    lines.add(s);
                }
            } else {
                lines.add(LanguageUtility.getLocalName("explosive.error.null_ex"));
            }
        } else {
            lines.add(LanguageUtility.getLocalName("error.null_stack"));
        }
    }

    @Deprecated
    public static void getSubItems(Item item, List list) {
        for (IExplosiveHandler ex : ExplosiveRegistry.getExplosives()) {
            ItemStack stack = new ItemStack(item);
            ExplosiveItemUtility.setExplosive(stack, ex);
            ExplosiveItemUtility.setSize(stack, 1.0);
            list.add(stack);
        }
    }

    public static IExplosiveHandler getExplosive(ItemStack itemStack) {
        return ExplosiveItemUtility.getExplosive(itemStack.func_77978_p());
    }

    public static IExplosiveHandler getExplosive(NBTTagCompound tag) {
        if (tag != null) {
            return ExplosiveRegistry.get(tag.func_74779_i(EXPLOSIVE_SAVE));
        }
        return null;
    }

    public static void setExplosive(ItemStack itemStack, String ex) {
        ExplosiveItemUtility.setExplosive(itemStack, ExplosiveRegistry.get(ex));
    }

    public static void setExplosive(ItemStack itemStack, IExplosiveHandler ex) {
        if (ex != null) {
            if (itemStack.func_77978_p() == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            ExplosiveItemUtility.setExplosive(itemStack.func_77978_p(), ex);
        } else if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b(EXPLOSIVE_SAVE)) {
            itemStack.func_77978_p().func_82580_o(EXPLOSIVE_SAVE);
        }
    }

    public static void setExplosive(NBTTagCompound tag, IExplosiveHandler ex) {
        if (ex != null) {
            tag.func_74778_a(EXPLOSIVE_SAVE, ex.getID());
        }
    }

    public static int getSize(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        return ExplosiveItemUtility.getSize(itemStack.func_77978_p());
    }

    public static int getSize(NBTTagCompound tag) {
        return tag.func_74762_e(SIZE_SAVE);
    }

    public static NBTTagCompound setSize(ItemStack itemStack, double size) {
        if (size != 0.0) {
            if (itemStack.func_77978_p() == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            return ExplosiveItemUtility.setSize(itemStack.func_77978_p(), size);
        }
        if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b(SIZE_SAVE)) {
            itemStack.func_77978_p().func_82580_o(SIZE_SAVE);
        }
        return itemStack.func_77978_p();
    }

    public static NBTTagCompound setSize(NBTTagCompound tag, double size) {
        tag.func_74780_a(SIZE_SAVE, size);
        return tag;
    }
}

