/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.debug.gui.panels.recipes;

import com.builtbroken.mc.debug.data.IJsonDebugData;
import com.builtbroken.mc.debug.gui.panels.imp.PanelDataList;
import com.builtbroken.mc.lib.data.StringComparator;
import com.builtbroken.mc.lib.helper.ReflectionUtility;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.StatCollector;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class TabPanelShapedRecipes
extends PanelDataList<ShapedRecipeData> {
    @Override
    protected IJsonDebugData getDataEntryFor(ShapedRecipeData object) {
        return object;
    }

    @Override
    protected void buildData() {
        try {
            this.data.clear();
            for (Object r : CraftingManager.func_77594_a().func_77592_b()) {
                if (r instanceof ShapedRecipes) {
                    ShapedRecipeData recipeData = new ShapedRecipeData();
                    recipeData.recipeWidth = ((ShapedRecipes)r).field_77576_b;
                    recipeData.recipeHeight = ((ShapedRecipes)r).field_77577_c;
                    recipeData.recipeOutput = ((ShapedRecipes)r).func_77571_b();
                    recipeData.recipeItems = ((ShapedRecipes)r).field_77574_d;
                    this.data.add(recipeData);
                    continue;
                }
                if (!(r instanceof ShapedOreRecipe)) continue;
                ShapedRecipeData shapedRecipe = new ShapedRecipeData();
                shapedRecipe.recipeWidth = (Integer)ReflectionUtility.getPrivateValue(ShapedOreRecipe.class, (Object)((ShapedOreRecipe)r), (String[])new String[]{"width"});
                shapedRecipe.recipeHeight = (Integer)ReflectionUtility.getPrivateValue(ShapedOreRecipe.class, (Object)((ShapedOreRecipe)r), (String[])new String[]{"height"});
                shapedRecipe.recipeOutput = ((ShapedOreRecipe)r).func_77571_b();
                shapedRecipe.recipeItems = ((ShapedOreRecipe)r).getInput();
                this.data.add(shapedRecipe);
            }
            Collections.sort(this.data, new FurnaceDataSorter());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class FurnaceDataSorter
    implements Comparator<ShapedRecipeData> {
        protected final StringComparator stringComparator = new StringComparator();

        @Override
        public int compare(ShapedRecipeData o1, ShapedRecipeData o2) {
            String regName1 = Item.field_150901_e.func_148750_c((Object)o1.recipeOutput.func_77973_b());
            String regName2 = Item.field_150901_e.func_148750_c((Object)o2.recipeOutput.func_77973_b());
            if (regName1 == null) {
                return -1;
            }
            if (regName2 == null) {
                return 1;
            }
            int result = this.stringComparator.compare(o1.getMod(), o2.getMod());
            if (result == 0) {
                return this.stringComparator.compare(o1.getName(), o2.getName());
            }
            return result;
        }
    }

    public static class ShapedRecipeData
    implements IJsonDebugData {
        public int recipeWidth;
        public int recipeHeight;
        public Object[] recipeItems;
        private ItemStack recipeOutput;

        @Override
        public String buildDebugLineDisplay() {
            String text = "<html>";
            text = text + "<h3>Output: " + this.asString(this.recipeOutput) + "</h3>";
            text = text + "<p>Size: " + this.recipeWidth + "x" + this.recipeHeight + "</p>";
            text = text + "<table>";
            for (int w = 0; w < this.recipeWidth; ++w) {
                text = text + "<tr>";
                for (int h = 0; h < this.recipeHeight; ++h) {
                    int index = h + w * this.recipeWidth;
                    if (index >= this.recipeItems.length) continue;
                    text = text + "<td>" + this.asString(this.recipeItems[index]) + "</td>";
                }
                text = text + "</tr>";
            }
            text = text + "</table>";
            text = text + "</html>";
            return text;
        }

        protected String asString(Object object) {
            if (object instanceof ItemStack) {
                ItemStack stack = (ItemStack)object;
                if (stack.func_77973_b() != null) {
                    String name = Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()).split(":")[0];
                    return "[" + name + " : " + this.getName(stack) + "]";
                }
                return "null item";
            }
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof List) {
                if (((List)object).size() > 0) {
                    if (((List)object).size() > 1) {
                        String t = "[";
                        for (Object o : (List)object) {
                            t = t + this.asString(o) + (o != ((List)object).get(((List)object).size() - 1) ? ", " : "");
                        }
                        return t + "]";
                    }
                    return this.asString(((List)object).get(0));
                }
                return "_";
            }
            return object != null ? object.toString() : "";
        }

        public String getMod() {
            return this.getMod(this.recipeOutput);
        }

        public String getMod(ItemStack stack) {
            String regName;
            if (stack != null && stack.func_77973_b() != null && (regName = Item.field_150901_e.func_148750_c((Object)stack.func_77973_b())) != null) {
                return regName.split(":")[0];
            }
            return "null";
        }

        public String getName() {
            return this.getName(this.recipeOutput);
        }

        public String getName(ItemStack stack) {
            String regName = Item.field_150901_e.func_148750_c((Object)stack.func_77973_b());
            String name = regName.split(":")[1];
            for (String value : new String[]{stack.func_82833_r(), stack.func_77977_a(), name, StatCollector.func_74838_a((String)stack.func_77973_b().func_77658_a()) + " " + stack.func_77960_j()}) {
                if (value == null || (value = value.trim()).isEmpty() || value.toLowerCase().startsWith("null")) continue;
                return value;
            }
            return stack.func_77973_b().func_77658_a() + "@" + stack.func_77960_j();
        }
    }
}

