/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.network.packet.callback;

import com.builtbroken.mc.api.tile.access.IGuiTile;
import com.builtbroken.mc.api.tile.node.ITileNodeHost;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.imp.transform.vector.Location;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketOpenGUI
extends PacketTile {
    public PacketOpenGUI() {
    }

    public PacketOpenGUI(int x, int y, int z, int guiID) {
        super(x, y, z, guiID);
    }

    public PacketOpenGUI(TileEntity tile, int guiID) {
        super(tile, guiID);
    }

    @Override
    public void handle(EntityPlayer player, TileEntity tile) {
        if (!player.field_70170_p.field_72995_K) {
            IGuiTile guiTile = null;
            if (tile instanceof IGuiTile) {
                guiTile = (IGuiTile)tile;
            } else if (tile instanceof ITileNodeHost && ((ITileNodeHost)tile).getTileNode() instanceof IGuiTile) {
                guiTile = (IGuiTile)((Object)((ITileNodeHost)tile).getTileNode());
            }
            if (guiTile != null) {
                ByteBuf buf = this.data().slice();
                int guiID = buf.readInt();
                if (!guiTile.openGui(player, guiID)) {
                    Engine.logger().error("Failed to open gui with ID(" + guiID + ") at location " + new Location(player.field_70170_p, this.x, this.y, this.z) + ", tile = " + tile);
                }
            } else if (Engine.runningAsDev) {
                Engine.logger().error("Tile at location " + new Location(player.field_70170_p, this.x, this.y, this.z) + " is not an instance of ITileGUI, tile = " + tile);
            }
        } else if (Engine.runningAsDev) {
            Engine.logger().error("Can not open GUI on client using PacketOpenGUI, tile = " + tile);
        }
    }
}

