/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.network.packet.callback;

import com.builtbroken.mc.api.data.IPacket;
import com.builtbroken.mc.api.event.TriggerCauseRegistry;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.explosive.ExplosiveRegistry;
import com.builtbroken.mc.framework.explosive.blast.Blast;
import com.builtbroken.mc.lib.world.edit.BlockEdit;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class PacketBlast
implements IPacket {
    public Blast blast;
    public BlastPacketType type;
    public IExplosiveHandler handler;
    public BlockEdit edit;
    private double x;
    private double y;
    private double z;
    private double size;

    public PacketBlast() {
    }

    public PacketBlast(Blast blast, BlastPacketType type) {
        this.blast = blast;
        this.handler = blast.explosiveHandler;
        this.type = type;
    }

    public PacketBlast(Blast blast, BlockEdit edit) {
        this(blast, BlastPacketType.EDIT_DISPLAY);
        this.edit = edit;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.type.ordinal());
        buffer.writeDouble(this.blast.x());
        buffer.writeDouble(this.blast.y());
        buffer.writeDouble(this.blast.z());
        buffer.writeDouble(this.blast.size);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.handler.getID());
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("a", true);
        if (this.blast.cause != null) {
            tag.func_74782_a("trigger", (NBTBase)TriggerCauseRegistry.cache(this.blast.cause));
        }
        if (this.blast.getAdditionBlastData() != null && !this.blast.getAdditionBlastData().func_82582_d()) {
            tag.func_74782_a("explosiveData", (NBTBase)this.blast.getAdditionBlastData());
        }
        if (this.type == BlastPacketType.EDIT_DISPLAY) {
            tag.func_74782_a("edit", (NBTBase)this.edit.toNBT());
        }
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)tag);
        this.blast.writeBytes(buffer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.type = BlastPacketType.values()[buffer.readInt()];
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
        this.size = buffer.readDouble();
        String id = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.handler = ExplosiveRegistry.get(id);
        if (this.handler == null) {
            Engine.logger().error("Failed to load handler[" + id + "] from packet data");
        }
        NBTTagCompound save2 = ByteBufUtils.readTag((ByteBuf)buffer);
        this.blast = (Blast)this.handler.createBlastForTrigger((World)Minecraft.func_71410_x().field_71441_e, this.x, this.y, this.z, TriggerCauseRegistry.rebuild(save2.func_74775_l("trigger"), (World)Minecraft.func_71410_x().field_71441_e), this.size, save2.func_74775_l("explosiveData"));
        if (this.type == BlastPacketType.EDIT_DISPLAY) {
            this.edit = new BlockEdit(save2.func_74775_l("edit"));
        }
        this.blast.readBytes(buffer);
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        try {
            if (this.blast != null) {
                switch (this.type) {
                    case PRE_BLAST_DISPLAY: {
                        this.blast.doStartDisplay();
                        break;
                    }
                    case POST_BLAST_DISPLAY: {
                        this.blast.doEndDisplay();
                        break;
                    }
                    case EDIT_DISPLAY: {
                        this.blast.displayEffectForEdit(this.edit);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }

    public static enum BlastPacketType {
        PRE_BLAST_DISPLAY,
        POST_BLAST_DISPLAY,
        EDIT_DISPLAY;

    }
}

