/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.content.world;

import com.builtbroken.mc.core.content.world.WorldGenWrapper;
import com.builtbroken.mc.core.content.world.chunks.ChunkProviderChess;
import com.builtbroken.mc.core.content.world.chunks.ChunkProviderEmpty;
import com.builtbroken.mc.core.content.world.chunks.ChunkProviderStone;
import com.builtbroken.mc.framework.mod.loadable.AbstractLoadable;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public final class DevWorldLoader
extends AbstractLoadable {
    public static WorldType emptyWorldGenerator;
    public static WorldType stoneWorldGenerator;
    private boolean hasWrapperedGenerators = false;

    @Override
    public void preInit() {
        emptyWorldGenerator = new WorldType("voidTestWorld"){

            public IChunkProvider getChunkGenerator(World world, String generatorOptions) {
                return new ChunkProviderEmpty(world);
            }

            public boolean func_77126_d() {
                return true;
            }
        };
        stoneWorldGenerator = new WorldType("stoneTestWorld"){

            public IChunkProvider getChunkGenerator(World world, String generatorOptions) {
                return new ChunkProviderStone(world);
            }

            public boolean func_77126_d() {
                return true;
            }
        };
        stoneWorldGenerator = new WorldType("chessTestWorld"){

            public IChunkProvider getChunkGenerator(World world, String generatorOptions) {
                return new ChunkProviderChess(world);
            }

            public boolean func_77126_d() {
                return true;
            }
        };
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.world.field_73011_w.field_76574_g == 0) {
            this.wrapperWorldGenerators();
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    protected void wrapperWorldGenerators() {
        if (!this.hasWrapperedGenerators) {
            this.hasWrapperedGenerators = true;
            try {
                Field worldGeneratorsField = GameRegistry.class.getDeclaredField("worldGenerators");
                worldGeneratorsField.setAccessible(true);
                Field worldGeneratorIndexField = GameRegistry.class.getDeclaredField("worldGeneratorIndex");
                worldGeneratorIndexField.setAccessible(true);
                Set oldSet = (Set)worldGeneratorsField.get(null);
                Map oldSetIndex = (Map)worldGeneratorIndexField.get(null);
                HashMap newGenerators = new HashMap();
                Iterator it = oldSet.iterator();
                while (it.hasNext()) {
                    IWorldGenerator gen = (IWorldGenerator)it.next();
                    newGenerators.put(new WorldGenWrapper(gen), oldSetIndex.get(gen));
                    oldSetIndex.remove(gen);
                    it.remove();
                }
                for (Map.Entry entry : newGenerators.entrySet()) {
                    GameRegistry.registerWorldGenerator((IWorldGenerator)((IWorldGenerator)entry.getKey()), (int)((Integer)entry.getValue()));
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

