/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.commands.prefab;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class AbstractCommand
extends CommandBase {
    protected final String name;

    public AbstractCommand(String name) {
        this.name = name;
    }

    public String func_71517_b() {
        return this.name;
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return "/" + this.func_71517_b() + " help";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (!(this.handleHelp(sender, args) || sender instanceof EntityPlayer && this.handleEntityPlayerCommand((EntityPlayer)sender, args) || this.handleConsoleCommand(sender, args))) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Error: Unknown chat command"));
        }
    }

    public boolean isHelpCommand(String[] args) {
        return args == null || args.length == 0 || args[0] == null || args[0].equalsIgnoreCase("help") || args[0].equalsIgnoreCase("?");
    }

    public boolean handleHelp(ICommandSender sender, String[] args) {
        if (this.isHelpCommand(args)) {
            int p = 0;
            if (args != null && args.length >= 2) {
                try {
                    p = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.printHelp(sender, p);
            return true;
        }
        return false;
    }

    public boolean handleEntityPlayerCommand(EntityPlayer player, String[] args) {
        return false;
    }

    public boolean handleConsoleCommand(ICommandSender sender, String[] args) {
        return false;
    }

    protected void printHelp(ICommandSender sender, int p) {
        ArrayList<String> items = new ArrayList<String>();
        this.getHelpOutput(sender, items);
        int pages = items.size() / 10;
        String header = "====== help -" + this.getPrefix().replace("/", "");
        if (pages > 1) {
            header = header + "- page " + p + " of " + pages;
        }
        sender.func_145747_a((IChatComponent)new ChatComponentText(header + " ======"));
        for (int i = 0 + p * 10; i < 10 + p * 10 && i < items.size(); ++i) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(this.getPrefix() + " " + (String)items.get(i)));
        }
        sender.func_145747_a((IChatComponent)new ChatComponentText(""));
    }

    public String getPrefix() {
        return "/" + this.func_71517_b();
    }

    public void getHelpOutput(ICommandSender sender, List<String> items) {
        items.add("help");
    }

    protected final String[] playersOnlineByUsername() {
        return MinecraftServer.func_71276_C().func_71213_z();
    }

    protected final List<EntityPlayer> getPlayersOnline() {
        return MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
    }

    protected void addChatToPlayers(List<EntityPlayer> players, String msg) {
        ChatComponentText chatComponentText = new ChatComponentText(msg);
        for (EntityPlayer player : players) {
            player.func_146105_b((IChatComponent)chatComponentText);
        }
    }

    protected void addChatToAllPlayers(String msg) {
        this.addChatToPlayers(this.getPlayersOnline(), msg);
    }

    public final String combine(String[] args) {
        return this.combine(args, 0, args.length);
    }

    public final String combine(String[] args, int start, int end) {
        String s = args[start];
        for (int i = start + 1; i < args.length && i < end; ++i) {
            s = s + " " + args[i];
        }
        return s.trim();
    }

    protected String[] removeFront(String[] array) {
        return this.removeFront(array, 1);
    }

    protected String[] removeFront(String[] array, int count) {
        if (count <= 0) {
            count = 1;
        }
        if (array.length > count) {
            String[] a = new String[array.length - count];
            for (int i = 0; i < a.length; ++i) {
                a[i] = array[i + count];
            }
            return a;
        }
        return new String[0];
    }

    public int func_82362_a() {
        return 2;
    }
}

