/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core;

import com.builtbroken.mc.abstraction.EngineLoader;
import com.builtbroken.mc.api.abstraction.imp.IMinecraftInterface;
import com.builtbroken.mc.api.abstraction.world.IWorld;
import com.builtbroken.mc.core.content.resources.DefinedGenItems;
import com.builtbroken.mc.core.content.tool.ItemSheetMetalTools;
import com.builtbroken.mc.core.content.tool.ItemSimpleCraftingTool;
import com.builtbroken.mc.core.network.netty.PacketManager;
import com.builtbroken.mc.framework.json.settings.JsonSettingData;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Engine {
    protected static Logger logger = LogManager.getLogger((String)"VoltzEngine");
    public static IMinecraftInterface minecraft;
    public static EngineLoader loaderInstance;
    public static final boolean runningAsDev;
    public static final HashMap<String, JsonSettingData> GLOBAL_SETTINGS;
    @Deprecated
    public static Block ore;
    @Deprecated
    public static Block gemOre;
    @Deprecated
    public static Block heatedStone;
    @Deprecated
    public static Block multiBlock;
    @Deprecated
    public static Item itemWrench;
    @Deprecated
    public static ItemSimpleCraftingTool itemSimpleCraftingTools;
    @Deprecated
    public static ItemSheetMetalTools itemSheetMetalTools;
    @Deprecated
    public static Item itemSheetMetal;
    @Deprecated
    public static Item itemCircuits;
    @Deprecated
    public static Item itemDevTool;
    @Deprecated
    public static Item itemCraftingParts;
    @Deprecated
    public static boolean metallicOresRequested;
    @Deprecated
    public static boolean gemOresRequested;
    @Deprecated
    public static boolean sheetMetalRequested;
    @Deprecated
    public static boolean multiBlockRequested;
    @Deprecated
    public static boolean craftingPartsRequested;
    @Deprecated
    public static boolean heatedRockRequested;
    @Deprecated
    public static boolean simpleToolsRequested;
    @Deprecated
    public static boolean circuitsRequested;
    @Deprecated
    public static final PacketManager packetHandler;
    protected static List<String> requestedContent;

    @Deprecated
    public static void requestOres() {
    }

    @Deprecated
    public static void requestMetalOres() {
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION)) {
            throw new RuntimeException("Ores can only be requested in Pre-Init phase!");
        }
        metallicOresRequested = true;
    }

    @Deprecated
    public static void requestGemOres() {
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION)) {
            throw new RuntimeException("Ores can only be requested in Pre-Init phase!");
        }
        gemOresRequested = true;
    }

    @Deprecated
    public static void requestResources() {
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION)) {
            throw new RuntimeException("Resources can only be requested in Pre-Init phase");
        }
        DefinedGenItems.DUST.requestToLoad();
        DefinedGenItems.DUST_IMPURE.requestToLoad();
        DefinedGenItems.RUBBLE.requestToLoad();
        DefinedGenItems.INGOT.requestToLoad();
        DefinedGenItems.PLATE.requestToLoad();
        DefinedGenItems.ROD.requestToLoad();
        DefinedGenItems.GEAR.requestToLoad();
        DefinedGenItems.NUGGET.requestToLoad();
        DefinedGenItems.WIRE.requestToLoad();
        DefinedGenItems.SCREW.requestToLoad();
    }

    @Deprecated
    public static void requestToolParts() {
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION)) {
            throw new RuntimeException("Tool Parts can only be requested in Pre-Init phase");
        }
        DefinedGenItems.AX_HEAD.requestToLoad();
        DefinedGenItems.SHOVEL_HEAD.requestToLoad();
        DefinedGenItems.HOE_HEAD.requestToLoad();
        DefinedGenItems.PICK_HEAD.requestToLoad();
        DefinedGenItems.SWORD_BLADE.requestToLoad();
    }

    @Deprecated
    public static void requestCircuits() {
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION)) {
            throw new RuntimeException("Circuit content can only be requested in Pre-Init phase");
        }
        circuitsRequested = true;
    }

    @Deprecated
    public static void requestCraftingParts() {
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION)) {
            throw new RuntimeException("Crafting parts can only be requested in Pre-Init phase");
        }
        craftingPartsRequested = true;
    }

    @Deprecated
    public static void requestMultiBlock() {
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION)) {
            throw new RuntimeException("Multi block content can only be requested in Pre-Init phase");
        }
        multiBlockRequested = true;
    }

    @Deprecated
    public static void requestSimpleTools() {
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION)) {
            throw new RuntimeException("Simple tool content can only be requested in Pre-Init phase");
        }
        simpleToolsRequested = true;
    }

    @Deprecated
    public static void requestSheetMetalContent() {
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION)) {
            throw new RuntimeException("Sheet metal content can only be requested in Pre-Init phase");
        }
        sheetMetalRequested = true;
    }

    @Deprecated
    public static void requestBaseModules() {
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION)) {
            throw new RuntimeException("Modules can only be requested to load in the pre-init phase");
        }
        Engine.requestResources();
        Engine.requestCraftingParts();
        Engine.requestCircuits();
        Engine.requestSimpleTools();
        Engine.requestSheetMetalContent();
    }

    public static Logger logger() {
        return logger;
    }

    public static void error(String msg, Throwable error) throws Throwable {
        if (loaderInstance == null) {
            throw new RuntimeException(msg, error);
        }
        Engine.logger().error(msg, error);
    }

    public static void error(String msg) {
        if (loaderInstance == null) {
            throw new RuntimeException(msg);
        }
        Engine.logger().error(msg);
    }

    public static boolean isJUnitTest() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        List<StackTraceElement> list = Arrays.asList(stackTrace);
        for (StackTraceElement element : list) {
            if (!element.getClassName().startsWith("org.junit.") && !element.getClassName().startsWith("com.builtbroken.mc.testing.junit.VoltzTestRunner")) continue;
            return true;
        }
        return false;
    }

    public static IWorld getWorld(int dim) {
        return minecraft != null ? minecraft.getWorld(dim) : null;
    }

    public static boolean isShiftHeld() {
        return minecraft.isShiftHeld();
    }

    @Deprecated
    public static Side getEffectiveSide() {
        return FMLCommonHandler.instance().getEffectiveSide();
    }

    public static boolean shouldDoServerLogic() {
        return Engine.isJUnitTest() || Engine.getEffectiveSide() == Side.SERVER;
    }

    public static boolean shouldDoClientLogic() {
        return Engine.isJUnitTest() || Engine.getEffectiveSide() == Side.CLIENT;
    }

    public static void addSetting(JsonSettingData jsonSettingData) {
        GLOBAL_SETTINGS.put(jsonSettingData.key, jsonSettingData);
    }

    public static JsonSettingData getSetting(String key) {
        return GLOBAL_SETTINGS.get(key);
    }

    static {
        runningAsDev = System.getProperty("development") != null && System.getProperty("development").equalsIgnoreCase("true");
        GLOBAL_SETTINGS = new HashMap();
        ore = null;
        gemOre = null;
        metallicOresRequested = false;
        gemOresRequested = false;
        sheetMetalRequested = false;
        multiBlockRequested = false;
        craftingPartsRequested = false;
        heatedRockRequested = false;
        simpleToolsRequested = false;
        circuitsRequested = false;
        packetHandler = new PacketManager("voltzengine");
        requestedContent = new ArrayList<String>();
    }
}

