/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.client.json.render.item;

import com.builtbroken.mc.client.json.ClientDataHandler;
import com.builtbroken.mc.client.json.IJsonRenderStateProvider;
import com.builtbroken.mc.client.json.render.RenderData;
import com.builtbroken.mc.lib.render.RenderUtility;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemJsonRenderer
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        if (item.func_77973_b() instanceof IJsonRenderStateProvider) {
            RenderData data = ClientDataHandler.INSTANCE.getRenderData(((IJsonRenderStateProvider)item.func_77973_b()).getRenderContentID(type, item));
            if (data != null) {
                return data.shouldRenderType(type, null, item);
            }
            return type != IItemRenderer.ItemRenderType.INVENTORY;
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        if (item.func_77973_b() instanceof IJsonRenderStateProvider) {
            RenderData data = ClientDataHandler.INSTANCE.getRenderData(((IJsonRenderStateProvider)item.func_77973_b()).getRenderContentID(type, item));
            if (data != null) {
                return data.shouldRenderType(type, null, item);
            }
            return type != IItemRenderer.ItemRenderType.INVENTORY;
        }
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... dataArray) {
        List<String> renderStates;
        RenderData data = this.getRenderData(type, item, dataArray);
        GL11.glPushMatrix();
        if (data != null && (renderStates = this.getRenderStatesToTry(type, item, dataArray)) != null) {
            for (String s : renderStates) {
                if (s == null || !data.render(type, s, item)) continue;
                GL11.glPopMatrix();
                return;
            }
        }
        if (data == null || !data.render(type, null, item)) {
            this.doBackupRender(type);
        }
        GL11.glPopMatrix();
    }

    protected List<String> getRenderStatesToTry(IItemRenderer.ItemRenderType type, ItemStack item, Object ... dataArray) {
        return null;
    }

    protected RenderData getRenderData(IItemRenderer.ItemRenderType type, ItemStack item, Object ... dataArray) {
        if (item.func_77973_b() instanceof IJsonRenderStateProvider) {
            return ClientDataHandler.INSTANCE.getRenderData(((IJsonRenderStateProvider)item.func_77973_b()).getRenderContentID(type, item));
        }
        return null;
    }

    protected void doBackupRender(IItemRenderer.ItemRenderType type) {
        switch (type) {
            case INVENTORY: {
                GL11.glTranslatef((float)0.0f, (float)-0.1f, (float)0.0f);
                break;
            }
            case ENTITY: {
                GL11.glTranslatef((float)0.0f, (float)0.3f, (float)0.0f);
                break;
            }
            case EQUIPPED: {
                GL11.glRotatef((float)-75.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)30.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)0.2f, (float)-0.5f, (float)-0.0f);
                GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                GL11.glTranslatef((float)-0.4f, (float)1.3f, (float)1.0f);
                GL11.glRotatef((float)-30.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)13.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glScaled((double)1.8f, (double)1.8f, (double)1.8f);
            }
        }
        RenderUtility.renderCube(0.0, 0.0, 0.0, 1.0, 1.0, 1.0, Blocks.field_150360_v);
    }
}

