/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.client.json.models;

import com.builtbroken.mc.client.json.ClientDataHandler;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.debug.IJsonDebugDisplay;
import com.builtbroken.mc.framework.json.imp.IJsonProcessor;
import com.builtbroken.mc.framework.json.processors.JsonGenData;
import com.builtbroken.mc.lib.render.RenderUtility;
import com.builtbroken.mc.lib.render.model.loader.EngineModelLoader;
import java.awt.Color;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelCustom;

public class ModelData
extends JsonGenData
implements IJsonDebugDisplay {
    String key;
    String domain;
    String name;
    IModelCustom model;
    private boolean errorLock = false;
    private int errors = 0;
    private long lastError;

    public ModelData(IJsonProcessor processor, String key, String domain, String name) {
        super(processor);
        this.key = key;
        this.domain = domain;
        this.name = name;
    }

    public IModelCustom getModel() {
        if (this.model == null && !this.errorLock) {
            try {
                this.model = EngineModelLoader.loadModel(new ResourceLocation(this.domain, "models/" + this.name));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.errorLock = true;
            }
        }
        return this.model;
    }

    public void render(boolean renderOnlyParts, String ... parts) {
        block10: {
            if (!this.errorLock) {
                try {
                    if (parts != null) {
                        if (renderOnlyParts) {
                            this.model.renderOnly(parts);
                        } else {
                            this.model.renderAllExcept(parts);
                        }
                        break block10;
                    }
                    this.model.renderAll();
                }
                catch (Exception e) {
                    Engine.logger().error("Failed to render model " + this);
                    long time = System.nanoTime();
                    if (time - this.lastError > 10000L) {
                        this.lastError = time;
                        if (this.errors++ >= 5) {
                            this.errorLock = true;
                        }
                        break block10;
                    }
                    this.errors = 0;
                }
            } else if (Engine.runningAsDev) {
                RenderUtility.renderFloatingText("ErrorLocked: " + this, 0.0, 0.0, 0.0, Color.red.getRGB());
            }
        }
    }

    @Override
    public void onCreated() {
        ClientDataHandler.INSTANCE.addModel(this.key, this);
    }

    @Override
    public String getContentID() {
        return this.key;
    }

    @Override
    public String getUniqueID() {
        return this.name;
    }

    @Override
    public String getMod() {
        return this.domain;
    }

    @Override
    public String getDisplayName() {
        return this.getContentID();
    }

    @Override
    public void addDebugLines(List<String> lines) {
        lines.add("Model = " + this.getModel());
        lines.add("Domain = " + this.domain);
        lines.add("Path = " + this.name);
    }

    public String toString() {
        return "ModelData[" + this.key + " >> " + this.domain + ":" + this.name + " >> " + this.model + "]@" + this.hashCode();
    }
}

