/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import exterminatorjeff.undergroundbiomes.api.common.UBLogger;
import exterminatorjeff.undergroundbiomes.client.UBOreModelResourceLocation;
import exterminatorjeff.undergroundbiomes.intermod.OresRegistry;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class UBOreModel
implements IModel {
    public static final UBLogger LOGGER = new UBLogger(UBOreModel.class, Level.INFO);
    public static final String UBORE_MODEL_NAME = "custom_ore";
    public static final String UBORE_MODEL_PATH = "undergroundbiomes:block/custom_ore";
    private final ResourceLocation stoneTexture;
    private final ResourceLocation oreTexture;
    private final IModel baseModel;

    public UBOreModel(UBOreModelResourceLocation location) {
        IModel baseModel = null;
        try {
            baseModel = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(UBORE_MODEL_PATH));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.baseModel = baseModel;
        this.stoneTexture = new ResourceLocation("undergroundbiomes:blocks/" + location.func_177518_c());
        this.oreTexture = OresRegistry.INSTANCE.getOverlayFor(location.ubOre.baseOre, location.ubOre.baseOreMeta);
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableSet.of();
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableSet.of();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IModel finalModel = this.baseModel.retexture(ImmutableMap.of((Object)"stone", (Object)this.stoneTexture.toString(), (Object)"ore", (Object)this.oreTexture.toString()));
        return finalModel.bake(state, format, bakedTextureGetter);
    }

    public IModelState getDefaultState() {
        return ModelRotation.X0_Y0;
    }
}

