/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.api.names;

import exterminatorjeff.undergroundbiomes.api.common.UBStairs;
import exterminatorjeff.undergroundbiomes.api.names.Entry;
import exterminatorjeff.undergroundbiomes.api.names.StoneEntry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.registries.IForgeRegistry;

public class StairsEntry
extends Entry<UBStairs> {
    public StairsEntry(StoneEntry baseStoneEntry) {
        super(baseStoneEntry.internalName + "_stairs");
        baseStoneEntry.stairs = this;
    }

    public Item getItemBlock() {
        return ((UBStairs)this.getThing()).toItem();
    }

    public Block getBlock(EnumFacing facing) {
        if (facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
            return ((UBStairs)this.getThing()).getBlock(facing);
        }
        throw new RuntimeException("Stairs cannot be facing " + facing + "!");
    }

    protected UBStairs stairs() {
        return (UBStairs)this.getThing();
    }

    @Override
    protected void doRegisterItem(IForgeRegistry<Item> registry) {
        this.getItemBlock().func_77655_b(this.internalName);
        registry.register(this.getItemBlock().setRegistryName(this.internalName));
    }

    @Override
    protected void doRegisterBlock(IForgeRegistry<Block> registry) {
        this.getItemBlock().func_77655_b(this.internalName);
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            String name = this.internalName + "_" + facing;
            Block block = this.getBlock(facing);
            block.func_149663_c(name);
            registry.register(block.setRegistryName(name));
        }
    }

    @Override
    protected void doRegisterModel(IStateMapper stateMapper) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            for (int i = 0; i < 8; ++i) {
                ModelLoader.setCustomStateMapper((Block)this.getBlock(facing), (IStateMapper)stateMapper);
            }
        }
        for (int meta = 0; meta < this.stairs().getNbVariants(); ++meta) {
            ModelResourceLocation location = new ModelResourceLocation(StairsEntry.externalName(this.internalName), this.stairs().getVariantName(meta));
            ModelLoader.setCustomModelResourceLocation((Item)this.getItemBlock(), (int)meta, (ModelResourceLocation)location);
            LOGGER.debug("Model location: " + location);
        }
    }
}

