/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.net;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.corelib.net.Message;
import de.maxhenkel.car.entity.car.base.EntityCarBatteryBase;
import de.maxhenkel.car.net.MessageCenterCarClient;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class MessageCenterCar
implements Message<MessageCenterCar> {
    private UUID uuid;

    public MessageCenterCar() {
    }

    public MessageCenterCar(Player player) {
        this.uuid = player.m_142081_();
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        if (!context.getSender().m_142081_().equals(this.uuid)) {
            Main.LOGGER.error("The UUID of the sender was not equal to the packet UUID");
            return;
        }
        Entity riding = context.getSender().m_20202_();
        if (!(riding instanceof EntityCarBatteryBase)) {
            return;
        }
        EntityCarBatteryBase car = (EntityCarBatteryBase)riding;
        if (context.getSender().equals((Object)car.getDriver())) {
            car.centerCar();
        }
        MessageCenterCarClient msg = new MessageCenterCarClient(this.uuid);
        context.getSender().m_183503_().m_8795_(player -> player.m_20270_((Entity)car) <= 128.0f).forEach(player -> Main.SIMPLE_CHANNEL.sendTo((Object)msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT));
    }

    @Override
    public MessageCenterCar fromBytes(FriendlyByteBuf buf) {
        this.uuid = buf.m_130259_();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.uuid);
    }
}

