/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.config;

import de.maxhenkel.car.config.Fuel;
import de.maxhenkel.car.corelib.config.DynamicConfig;
import de.maxhenkel.car.fluids.ModFluids;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class FuelConfig
extends DynamicConfig {
    private Map<Fluid, Fuel> fuels = new HashMap<Fluid, Fuel>();

    @Override
    protected void setDefaults() {
        super.setDefaults();
        this.addFuel((Fluid)ModFluids.BIO_DIESEL, 100);
    }

    @Override
    protected void onLoad() {
        super.onLoad();
        this.fuels = this.getFuelsInternal();
    }

    private void addFuel(Fluid fluid, int efficiency) {
        String name = fluid.getRegistryName().toString();
        this.setObject(name, new Fuel(name, efficiency));
    }

    private Map<Fluid, Fuel> getFuelsInternal() {
        return this.getSubValues().stream().map(s -> this.getObject((String)s, () -> new Fuel((String)s))).filter(fuel -> fuel.getFluid() != Fluids.f_76191_).collect(Collectors.toMap(Fuel::getFluid, fuel -> fuel));
    }

    public Map<Fluid, Fuel> getFuels() {
        return this.fuels;
    }
}

