/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.blocks.BlockGui;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.car.corelib.item.ItemUtils;
import de.maxhenkel.car.recipes.EnergyFluidProducerRecipe;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public abstract class TileEntityEnergyFluidProducer
extends TileEntityBase
implements IEnergyStorage,
WorldlyContainer,
ITickableBlockEntity,
IFluidHandler {
    protected RecipeType<? extends EnergyFluidProducerRecipe> recipeType;
    protected SimpleContainer inventory;
    protected int maxEnergy;
    protected int storedEnergy;
    protected int time;
    protected int fluidAmount;
    protected int currentMillibuckets;
    public final ContainerData FIELDS = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return TileEntityEnergyFluidProducer.this.time;
                }
                case 1: {
                    return TileEntityEnergyFluidProducer.this.storedEnergy;
                }
                case 2: {
                    return TileEntityEnergyFluidProducer.this.currentMillibuckets;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityEnergyFluidProducer.this.time = value;
                    break;
                }
                case 1: {
                    TileEntityEnergyFluidProducer.this.storedEnergy = value;
                    break;
                }
                case 2: {
                    TileEntityEnergyFluidProducer.this.currentMillibuckets = value;
                }
            }
        }

        public int m_6499_() {
            return 3;
        }
    };

    public TileEntityEnergyFluidProducer(BlockEntityType<?> tileEntityTypeIn, RecipeType<? extends EnergyFluidProducerRecipe> recipeType, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.recipeType = recipeType;
        this.inventory = new SimpleContainer(2);
        this.maxEnergy = 10000;
        this.storedEnergy = 0;
        this.time = 0;
        this.fluidAmount = 3000;
        this.currentMillibuckets = 0;
    }

    public EnergyFluidProducerRecipe getRecipe() {
        return this.f_58857_.m_7465_().m_44015_(this.recipeType, (Container)this, this.f_58857_).orElse(null);
    }

    @Override
    public void tick() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        ItemStack input = this.inventory.m_8020_(0);
        ItemStack output = this.inventory.m_8020_(1);
        EnergyFluidProducerRecipe recipe = this.getRecipe();
        if (recipe == null) {
            this.time = 0;
            this.m_6596_();
            this.setBlockEnabled(false);
            return;
        }
        if (this.storedEnergy < recipe.getEnergy()) {
            this.setBlockEnabled(false);
            return;
        }
        if (input.m_41619_()) {
            this.time = 0;
            this.m_6596_();
            this.setBlockEnabled(false);
            return;
        }
        if (!(output.m_41619_() || ItemStack.m_41746_((ItemStack)output, (ItemStack)recipe.m_8043_()) && output.m_41613_() + recipe.m_8043_().m_41613_() <= output.m_41741_())) {
            this.time = 0;
            this.m_6596_();
            this.setBlockEnabled(false);
            return;
        }
        if (this.currentMillibuckets + recipe.getFluidAmount() > this.fluidAmount) {
            this.time = 0;
            this.m_6596_();
            this.setBlockEnabled(false);
            return;
        }
        ++this.time;
        this.storedEnergy -= recipe.getEnergy();
        if (this.time > recipe.getDuration()) {
            this.time = 0;
            if (output.m_41619_()) {
                this.inventory.m_6836_(1, recipe.m_8043_());
            } else if (output.m_41613_() < output.m_41741_()) {
                output.m_41769_(recipe.m_8043_().m_41613_());
            }
            this.currentMillibuckets += recipe.getFluidAmount();
            input.m_41774_(1);
        }
        this.m_6596_();
        this.setBlockEnabled(true);
    }

    public abstract BlockGui<? extends TileEntityEnergyFluidProducer> getOwnBlock();

    public void setBlockEnabled(boolean enabled) {
        BlockState state = this.f_58857_.m_8055_(this.m_58899_());
        if (state.m_60734_().equals(this.getOwnBlock())) {
            this.getOwnBlock().setPowered(this.f_58857_, this.f_58858_, state, enabled);
        }
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("energy_stored", this.storedEnergy);
        compound.m_128405_("time", this.time);
        compound.m_128405_("fluid_stored", this.currentMillibuckets);
        ItemUtils.saveInventory(compound, "slots", (Container)this.inventory);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.storedEnergy = compound.m_128451_("energy_stored");
        this.time = compound.m_128451_("time");
        this.currentMillibuckets = compound.m_128451_("fluid_stored");
        ItemUtils.readInventory(compound, "slots", (Container)this.inventory);
        super.m_142466_(compound);
    }

    public int m_6643_() {
        return this.inventory.m_6643_();
    }

    public ItemStack m_8020_(int index) {
        return this.inventory.m_8020_(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return this.inventory.m_7407_(index, count);
    }

    public ItemStack m_8016_(int index) {
        return this.inventory.m_8016_(index);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.inventory.m_6836_(index, stack);
    }

    public int m_6893_() {
        return this.inventory.m_6893_();
    }

    public boolean m_6542_(Player player) {
        return this.inventory.m_6542_(player);
    }

    public void m_5856_(Player player) {
        this.inventory.m_5856_(player);
    }

    public void m_5785_(Player player) {
        this.inventory.m_5785_(player);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return this.inventory.m_7013_(index, stack);
    }

    public void m_6211_() {
        this.inventory.m_6211_();
    }

    public boolean m_7983_() {
        return this.inventory.m_7983_();
    }

    public int[] m_7071_(Direction side) {
        return new int[]{0, 1};
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, Direction direction) {
        return index == 0;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return index == 1;
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public int getMaxEnergy() {
        return this.maxEnergy;
    }

    public int getStoredEnergy() {
        return this.storedEnergy;
    }

    public int getTimeToGenerate() {
        EnergyFluidProducerRecipe recipe = this.getRecipe();
        if (recipe == null) {
            return 0;
        }
        return recipe.getDuration();
    }

    public int getGeneratingTime() {
        return this.time;
    }

    public int getFluidAmount() {
        return this.fluidAmount;
    }

    public int getCurrentMillibuckets() {
        return this.currentMillibuckets;
    }

    public abstract Fluid getProducingFluid();

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyNeeded = this.maxEnergy - this.storedEnergy;
        if (!simulate) {
            this.storedEnergy += Math.min(energyNeeded, maxReceive);
            this.m_6596_();
        }
        return Math.min(energyNeeded, maxReceive);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.storedEnergy;
    }

    public int getMaxEnergyStored() {
        return this.maxEnergy;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    @Override
    public ContainerData getFields() {
        return this.FIELDS;
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return new FluidStack(this.getProducingFluid(), this.currentMillibuckets);
    }

    public int getTankCapacity(int tank) {
        return this.fluidAmount;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return stack.getFluid().equals(this.getProducingFluid());
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        int amount = Math.min(resource.getAmount(), this.currentMillibuckets);
        if (action.execute()) {
            this.currentMillibuckets -= amount;
            this.m_6596_();
        }
        return new FluidStack(this.getProducingFluid(), amount);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int amount = Math.min(maxDrain, this.currentMillibuckets);
        if (action.execute()) {
            this.currentMillibuckets -= amount;
            this.m_6596_();
        }
        return new FluidStack(this.getProducingFluid(), amount);
    }
}

