/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.util;

import java.util.List;
import java.util.function.Function;
import net.minecraft.block.PortalInfo;
import net.minecraft.entity.Entity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetPassengersPacket;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;

public class TeleportationUtils {
    public static Entity teleportEntity(Entity entity, RegistryKey<World> dimension, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        return TeleportationUtils.teleportEntityTo(entity, new BlockPos(xCoord, yCoord, zCoord), dimension, yaw, pitch);
    }

    public static Entity teleportEntityTo(Entity entity, BlockPos target, RegistryKey<World> destinationDimension, final float yaw, final float pitch) {
        if (entity.func_130014_f_().func_234923_W_() == destinationDimension) {
            entity.field_70177_z = yaw;
            entity.field_70125_A = pitch;
            entity.func_70634_a((double)target.func_177958_n() + 0.5, (double)target.func_177956_o(), (double)target.func_177952_p() + 0.5);
            if (!entity.func_184188_bt().isEmpty()) {
                ((ServerChunkProvider)entity.func_130014_f_().func_72863_F()).func_217218_b(entity, (IPacket)new SSetPassengersPacket(entity));
            }
            return entity;
        }
        ServerWorld newWorld = ((ServerWorld)entity.func_130014_f_()).func_73046_m().func_71218_a(destinationDimension);
        if (newWorld != null) {
            final Vector3d destination = new Vector3d((double)target.func_177958_n() + 0.5, (double)target.func_177956_o(), (double)target.func_177952_p() + 0.5);
            final List passengers = entity.func_184188_bt();
            return entity.changeDimension(newWorld, new ITeleporter(){

                public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw2, Function<Boolean, Entity> repositionEntity) {
                    Entity repositionedEntity = repositionEntity.apply(false);
                    if (repositionedEntity != null) {
                        for (Entity passenger : passengers) {
                            TeleportationUtils.teleportPassenger(destWorld, repositionedEntity, passenger);
                        }
                    }
                    return repositionedEntity;
                }

                public PortalInfo getPortalInfo(Entity entity, ServerWorld destWorld, Function<ServerWorld, PortalInfo> defaultPortalInfo) {
                    return new PortalInfo(destination, entity.func_213322_ci(), yaw, pitch);
                }
            });
        }
        return null;
    }

    private static void teleportPassenger(ServerWorld destWorld, final Entity repositionedEntity, Entity passenger) {
        final List passengers = passenger.func_184188_bt();
        passenger.changeDimension(destWorld, new ITeleporter(){

            public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                Entity repositionedPassenger = repositionEntity.apply(false);
                if (repositionedPassenger != null) {
                    repositionedPassenger.func_184205_a(repositionedEntity, true);
                    for (Entity passenger : passengers) {
                        TeleportationUtils.teleportPassenger(destWorld, repositionedPassenger, passenger);
                    }
                }
                return repositionedPassenger;
            }
        });
    }
}

