/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.itemstack;

import com.google.common.collect.Maps;
import com.hrznstudio.titanium.itemstack.ItemStackHarness;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemStackHarnessRegistry {
    private static final ItemStackHarnessRegistry INSTANCE = new ItemStackHarnessRegistry();
    private final Map<Item, Function<ItemStack, ItemStackHarness>> harnessCreators = Maps.newHashMap();

    public static void register(Item item, Function<ItemStack, ItemStackHarness> harnessCreator) {
        ItemStackHarnessRegistry.getHarnessCreators().put(item, harnessCreator);
    }

    public static Map<Item, Function<ItemStack, ItemStackHarness>> getHarnessCreators() {
        return ItemStackHarnessRegistry.getInstance().harnessCreators;
    }

    public static Optional<ItemStackHarness> createItemStackHarness(ItemStack itemStack) {
        return Optional.of(itemStack.func_77973_b()).map(ItemStackHarnessRegistry.getHarnessCreators()::get).map(harnessCreator -> (ItemStackHarness)harnessCreator.apply(itemStack));
    }

    public static ItemStackHarnessRegistry getInstance() {
        return INSTANCE;
    }
}

