/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tmechworks.client.gui.components;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.util.vector.Vector2f;
import slimeknights.tmechworks.library.Util;

public class GuiArrowSelection
extends GuiButton {
    public static String[] LABELSET_DEFAULT = new String[]{"Down", "Up", "Front", "Back", "Left", "Right", "Place High", "Place Middle", "Place Low"};
    private static final int ARROW_SIZE = 20;
    private static final int ARROW_SMALL_SIZE = 6;
    private static final int ARROW_ROWS = 2;
    private static final ResourceLocation textures = Util.getResource("textures/gui/arrows.png");
    private String[] labelset;
    private ArrowState[] states = new ArrowState[Arrow.values().length];
    private Arrow hoveredArrow;
    private int screenW;
    private int screenH;

    public GuiArrowSelection(int buttonId, int x, int y, int screenW, int screenH) {
        this(buttonId, x, y, screenW, screenH, false);
    }

    public GuiArrowSelection(int buttonId, int x, int y, int screenW, int screenH, boolean drawAdditionalArrows) {
        super(buttonId, x, y, "");
        this.setLabelSet(LABELSET_DEFAULT);
        Arrays.fill((Object[])this.states, (Object)ArrowState.ENABLED);
        if (!drawAdditionalArrows) {
            for (int i = Arrow.MID_UP.ordinal(); i < Arrow.values().length; ++i) {
                this.states[i] = ArrowState.NO_DRAW;
            }
        }
        this.screenW = screenW;
        this.screenH = screenH;
    }

    public GuiArrowSelection setLabelSet(String[] labels) {
        if (labels.length < Arrow.values().length) {
            this.labelset = new String[Arrow.values().length];
            Arrays.fill(this.labelset, "");
            for (int i = 0; i < this.labelset.length; ++i) {
                if (i >= labels.length) continue;
                this.labelset[i] = labels[i];
            }
        } else {
            this.labelset = labels;
        }
        return this;
    }

    public ArrowState getState(Arrow arrow) {
        return this.states[arrow.ordinal()];
    }

    public GuiArrowSelection setState(Arrow arrow, ArrowState state) {
        this.states[arrow.ordinal()] = state;
        return this;
    }

    public Arrow getHoveredArrow() {
        return this.hoveredArrow;
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        ArrowState state;
        Arrow arrow;
        int i;
        if (!this.field_146125_m) {
            return;
        }
        Arrow.SMALL_DOWN.position.y = 28.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.field_146128_h, (float)this.field_146129_i, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(textures);
        this.hoveredArrow = null;
        boolean canHover = true;
        for (i = 0; i < Arrow.values().length; ++i) {
            arrow = Arrow.values()[i];
            state = this.states[i];
            if (state == ArrowState.NO_DRAW) continue;
            if (state != ArrowState.DISABLED && state != ArrowState.SELECTED) {
                if (canHover && this.hoveredArrow == null && arrow.isHovered(this.field_146128_h, this.field_146129_i, mouseX, mouseY)) {
                    this.states[i] = ArrowState.HOVER;
                    this.hoveredArrow = arrow;
                    canHover = false;
                    continue;
                }
                this.states[i] = ArrowState.ENABLED;
                continue;
            }
            if (!arrow.isHovered(this.field_146128_h, this.field_146129_i, mouseX, mouseY)) continue;
            canHover = false;
        }
        for (i = 0; i < Arrow.values().length; ++i) {
            arrow = Arrow.values()[i];
            state = this.states[i];
            if (state == ArrowState.NO_DRAW) continue;
            int indexX = arrow.indexX * arrow.w + arrow.subX * arrow.subW;
            int indexY = (arrow.indexY + state.ordinal() * 2) * arrow.h + arrow.subY * arrow.subH;
            this.func_175174_a(arrow.position.getX(), arrow.position.getY(), indexX, indexY, arrow.subW, arrow.subH);
        }
        GlStateManager.func_179121_F();
    }

    public void func_146111_b(int mouseX, int mouseY) {
        if (this.hoveredArrow == null) {
            return;
        }
        if (this.labelset != null && this.states[this.hoveredArrow.ordinal()] == ArrowState.HOVER && !this.labelset[this.hoveredArrow.ordinal()].trim().isEmpty()) {
            GuiUtils.drawHoveringText((List)ImmutableList.of((Object)this.labelset[this.hoveredArrow.ordinal()]), (int)mouseX, (int)mouseY, (int)this.screenW, (int)this.screenH, (int)100, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
        }
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        return this.hoveredArrow != null;
    }

    public static enum ArrowState {
        ENABLED,
        DISABLED,
        HOVER,
        SELECTED,
        NO_DRAW;

    }

    public static enum Arrow {
        MID_DOWN(2, 0, 0, 0, new Vector2f(13.0f, 29.0f)),
        MID_UP(2, 0, 0, 0, new Vector2f(13.0f, 13.0f)),
        UP(0, 0, new Vector2f(14.0f, 0.0f)),
        DOWN(1, 0, new Vector2f(14.0f, 28.0f)),
        LEFT(0, 1, new Vector2f(0.0f, 14.0f)),
        RIGHT(1, 1, new Vector2f(28.0f, 14.0f)),
        SMALL_UP(2, 0, 1, 0, new Vector2f(50.0f, 15.0f)),
        SMALL_MID(2, 0, 0, 1, new Vector2f(50.0f, 21.0f)),
        SMALL_DOWN(2, 0, 1, 1, new Vector2f(50.0f, 29.0f));

        public final int indexX;
        public final int indexY;
        public final int w;
        public final int h;
        public final int subX;
        public final int subY;
        public final int subW;
        public final int subH;
        public final Vector2f position;

        private Arrow(int indexX, int indexY, Vector2f pos) {
            this(indexX, indexY, 20, 20, 0, 0, 20, 20, pos);
        }

        private Arrow(int indexX, int indexY, int subX, int subY, Vector2f pos) {
            this(indexX, indexY, 20, 20, subX, subY, 6, 6, pos);
        }

        private Arrow(int indexX, int indexY, int w, int h, int subX, int subY, int subW, int subH, Vector2f pos) {
            this.indexX = indexX;
            this.indexY = indexY;
            this.w = w;
            this.h = h;
            this.subX = subX;
            this.subY = subY;
            this.subW = subW;
            this.subH = subH;
            this.position = pos;
        }

        public boolean isHovered(int xPosition, int yPosition, int mouseX, int mouseY) {
            return (float)mouseX > (float)xPosition + this.position.getX() && (float)mouseX < (float)xPosition + this.position.getX() + (float)this.subW && (float)mouseY > (float)yPosition + this.position.getY() && (float)mouseY < (float)yPosition + this.position.getY() + (float)this.subH;
        }
    }
}

