/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.api.energy.IEnergyReceiver;
import cofh.core.CoFHProps;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.block.device.TileDeviceBase;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileExtender
extends TileDeviceBase
implements IFluidHandler {
    static final int MAX_CACHE_LEVEL = 128;
    static int[][] slotsCache = new int[128][];
    ISidedInventory targetInventorySided;
    IInventory targetInventory;
    IEnergyReceiver targetReceiver;
    IFluidHandler targetHandler;
    TileEntity targetTile;
    boolean cached = false;
    boolean polling = false;

    public static void initialize() {
        int n = BlockDevice.Types.EXTENDER.ordinal();
        TileDeviceBase.defaultSideConfig[n] = new TileTEBase.SideConfig();
        TileDeviceBase.defaultSideConfig[n].numConfig = 2;
        TileDeviceBase.defaultSideConfig[n].slotGroups = new int[][]{new int[0], new int[0]};
        TileDeviceBase.defaultSideConfig[n].allowInsertionSide = new boolean[]{false, false};
        TileDeviceBase.defaultSideConfig[n].allowExtractionSide = new boolean[]{false, false};
        TileDeviceBase.defaultSideConfig[n].allowInsertionSlot = new boolean[0];
        TileDeviceBase.defaultSideConfig[n].allowExtractionSlot = new boolean[0];
        TileDeviceBase.defaultSideConfig[n].sideTex = new int[]{0, 7};
        TileDeviceBase.defaultSideConfig[n].defaultSides = new byte[]{0, 0, 0, 0, 0, 0};
        GameRegistry.registerTileEntity(TileExtender.class, (String)"thermalexpansion.Extender");
    }

    public static int[] getNonSidedSlots(int n) {
        if (n < 128 && slotsCache[n] != null) {
            return slotsCache[n];
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        if (n < 128) {
            TileExtender.slotsCache[n] = nArray;
        }
        return nArray;
    }

    public TileExtender() {
        super(BlockDevice.Types.EXTENDER);
    }

    @Override
    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.updateHandlers();
    }

    public void onNeighborTileChange(int n, int n2, int n3) {
        super.onNeighborTileChange(n, n2, n3);
        this.updateHandlers();
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.checkPollingAndNeighbor()) {
            return;
        }
        this.polling = true;
        if (this.targetTile != null) {
            this.targetTile.func_70296_d();
        }
        this.polling = false;
    }

    protected void updateHandlers() {
        this.cached = true;
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        this.targetTile = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)this.facing);
        if (this.targetTile != null) {
            if (this.targetTile.func_145837_r()) {
                this.targetTile = null;
            } else if (this.targetTile instanceof TileExtender) {
                this.targetTile = null;
            }
        }
        this.targetInventorySided = this.targetTile instanceof ISidedInventory ? (ISidedInventory)this.targetTile : null;
        this.targetInventory = this.targetTile instanceof IInventory ? (IInventory)this.targetTile : null;
        this.targetReceiver = this.targetTile instanceof IEnergyReceiver ? (IEnergyReceiver)this.targetTile : null;
        this.targetHandler = this.targetTile instanceof IFluidHandler ? (IFluidHandler)this.targetTile : null;
    }

    public boolean checkPollingAndNeighbor() {
        if (this.polling || ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return true;
        }
        if (!this.cached || this.targetTile != null && this.targetTile.func_145837_r()) {
            this.updateHandlers();
        }
        return this.targetTile != null && !this.targetTile.func_145837_r();
    }

    @Override
    public boolean rotateBlock() {
        super.rotateBlock();
        this.updateHandlers();
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        if (this.checkPollingAndNeighbor()) {
            return 0;
        }
        this.polling = true;
        int n2 = this.targetReceiver != null ? this.targetReceiver.receiveEnergy(ForgeDirection.VALID_DIRECTIONS[this.facing ^ 1], n, bl) : 0;
        this.polling = false;
        return n2;
    }

    @Override
    public int getEnergyStored(ForgeDirection forgeDirection) {
        if (this.checkPollingAndNeighbor()) {
            return 0;
        }
        this.polling = true;
        int n = this.targetReceiver != null ? this.targetReceiver.getEnergyStored(ForgeDirection.VALID_DIRECTIONS[this.facing ^ 1]) : 0;
        this.polling = false;
        return n;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection forgeDirection) {
        if (this.checkPollingAndNeighbor()) {
            return 0;
        }
        this.polling = true;
        int n = this.targetReceiver != null ? this.targetReceiver.getMaxEnergyStored(ForgeDirection.VALID_DIRECTIONS[this.facing ^ 1]) : 0;
        this.polling = false;
        return n;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection forgeDirection) {
        if (this.checkPollingAndNeighbor()) {
            return false;
        }
        this.polling = true;
        boolean bl = this.targetReceiver != null ? this.targetReceiver.canConnectEnergy(ForgeDirection.VALID_DIRECTIONS[this.facing ^ 1]) : false;
        this.polling = false;
        return bl;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (forgeDirection.ordinal() == this.facing) {
            return 0;
        }
        if (this.checkPollingAndNeighbor()) {
            return 0;
        }
        this.polling = true;
        int n = this.targetHandler != null ? this.targetHandler.fill(ForgeDirection.VALID_DIRECTIONS[this.facing ^ 1], fluidStack, bl) : 0;
        this.polling = false;
        return n;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (forgeDirection.ordinal() == this.facing) {
            return null;
        }
        if (this.checkPollingAndNeighbor()) {
            return null;
        }
        this.polling = true;
        FluidStack fluidStack2 = this.targetHandler != null ? this.targetHandler.drain(ForgeDirection.VALID_DIRECTIONS[this.facing ^ 1], fluidStack, bl) : null;
        this.polling = false;
        return fluidStack2;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        if (forgeDirection.ordinal() == this.facing) {
            return null;
        }
        if (this.checkPollingAndNeighbor()) {
            return null;
        }
        this.polling = true;
        FluidStack fluidStack = this.targetHandler != null ? this.targetHandler.drain(ForgeDirection.VALID_DIRECTIONS[this.facing ^ 1], n, bl) : null;
        this.polling = false;
        return fluidStack;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        if (forgeDirection.ordinal() == this.facing) {
            return false;
        }
        if (this.checkPollingAndNeighbor()) {
            return false;
        }
        this.polling = true;
        boolean bl = this.targetHandler != null ? this.targetHandler.canFill(ForgeDirection.VALID_DIRECTIONS[this.facing ^ 1], fluid) : false;
        this.polling = false;
        return bl;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        if (forgeDirection.ordinal() == this.facing) {
            return false;
        }
        if (this.checkPollingAndNeighbor()) {
            return false;
        }
        this.polling = true;
        boolean bl = this.targetHandler != null ? this.targetHandler.canDrain(ForgeDirection.VALID_DIRECTIONS[this.facing ^ 1], fluid) : false;
        this.polling = false;
        return bl;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        if (forgeDirection.ordinal() == this.facing) {
            return CoFHProps.EMPTY_TANK_INFO;
        }
        if (this.checkPollingAndNeighbor()) {
            return CoFHProps.EMPTY_TANK_INFO;
        }
        this.polling = true;
        FluidTankInfo[] fluidTankInfoArray = this.targetHandler != null ? this.targetHandler.getTankInfo(ForgeDirection.VALID_DIRECTIONS[this.facing ^ 1]) : CoFHProps.EMPTY_TANK_INFO;
        this.polling = false;
        return fluidTankInfoArray;
    }

    @Override
    public int func_70302_i_() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return 1;
        }
        if (this.checkPollingAndNeighbor()) {
            return 0;
        }
        this.polling = true;
        int n = this.targetInventory != null ? this.targetInventory.func_70302_i_() : 0;
        this.polling = false;
        return n;
    }

    @Override
    public ItemStack func_70301_a(int n) {
        if (this.checkPollingAndNeighbor()) {
            return null;
        }
        this.polling = true;
        ItemStack itemStack = this.targetInventory != null ? this.targetInventory.func_70301_a(n) : null;
        this.polling = false;
        return itemStack;
    }

    @Override
    public ItemStack func_70298_a(int n, int n2) {
        if (this.checkPollingAndNeighbor()) {
            return null;
        }
        this.polling = true;
        ItemStack itemStack = this.targetInventory != null ? this.targetInventory.func_70298_a(n, n2) : null;
        this.polling = false;
        return itemStack;
    }

    @Override
    public ItemStack func_70304_b(int n) {
        if (this.checkPollingAndNeighbor()) {
            return null;
        }
        this.polling = true;
        ItemStack itemStack = this.targetInventory != null ? this.targetInventory.func_70304_b(n) : null;
        this.polling = false;
        return itemStack;
    }

    @Override
    public void func_70299_a(int n, ItemStack itemStack) {
        if (this.checkPollingAndNeighbor()) {
            return;
        }
        this.polling = true;
        if (this.targetInventory != null) {
            this.targetInventory.func_70299_a(n, itemStack);
        }
        this.polling = false;
    }

    @Override
    public int func_70297_j_() {
        if (this.checkPollingAndNeighbor()) {
            return 64;
        }
        this.polling = true;
        int n = this.targetInventory != null ? this.targetInventory.func_70297_j_() : 64;
        this.polling = false;
        return n;
    }

    @Override
    public boolean func_94041_b(int n, ItemStack itemStack) {
        if (this.checkPollingAndNeighbor()) {
            return false;
        }
        this.polling = true;
        boolean bl = this.targetInventory != null ? this.targetInventory.func_94041_b(n, itemStack) : false;
        this.polling = false;
        return bl;
    }

    @Override
    public int[] func_94128_d(int n) {
        if (n == this.facing) {
            return CoFHProps.EMPTY_INVENTORY;
        }
        if (this.checkPollingAndNeighbor()) {
            return CoFHProps.EMPTY_INVENTORY;
        }
        this.polling = true;
        int[] nArray = this.targetInventorySided != null ? this.targetInventorySided.func_94128_d(n) : (this.targetInventory != null ? TileExtender.getNonSidedSlots(this.targetInventory.func_70302_i_()) : CoFHProps.EMPTY_INVENTORY);
        this.polling = false;
        return nArray;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        if (n2 == this.facing) {
            return false;
        }
        if (this.checkPollingAndNeighbor()) {
            return false;
        }
        this.polling = true;
        boolean bl = this.targetInventorySided != null ? this.targetInventorySided.func_102007_a(n, itemStack, n2) : this.targetInventory != null;
        this.polling = false;
        return bl;
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        if (n2 == this.facing) {
            return false;
        }
        if (this.checkPollingAndNeighbor()) {
            return false;
        }
        this.polling = true;
        boolean bl = this.targetInventorySided != null ? this.targetInventorySided.func_102008_b(n, itemStack, n2) : this.targetInventory != null;
        this.polling = false;
        return bl;
    }

    static {
        TileExtender.slotsCache[0] = CoFHProps.EMPTY_INVENTORY;
    }
}

