/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.client.machine;

import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.ElementBase;
import cofh.core.gui.element.ElementButton;
import cofh.core.gui.element.ElementDualScaled;
import cofh.core.gui.element.ElementEnergyStored;
import cofh.core.gui.element.ElementFluid;
import cofh.core.gui.element.ElementFluidTank;
import cofh.thermalexpansion.block.machine.TilePrecipitator;
import cofh.thermalexpansion.gui.client.GuiPoweredBase;
import cofh.thermalexpansion.gui.container.machine.ContainerPrecipitator;
import cofh.thermalexpansion.gui.element.ElementSlotOverlay;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.IFluidTank;

public class GuiPrecipitator
extends GuiPoweredBase {
    public static final String TEX_PATH = "thermalexpansion:textures/gui/machine/precipitator.png";
    public static final ResourceLocation TEXTURE = new ResourceLocation("thermalexpansion:textures/gui/machine/precipitator.png");
    private TilePrecipitator myTile;
    private ElementBase slotInput;
    private ElementBase slotOutput;
    private ElementFluid progressFluid;
    private ElementDualScaled progressOverlay;
    private ElementDualScaled speed;
    private ElementButton prevOutput;
    private ElementButton nextOutput;

    public GuiPrecipitator(InventoryPlayer inventory, TileEntity tile) {
        super((Container)new ContainerPrecipitator(inventory, tile), tile, inventory.field_70458_d, TEXTURE);
        this.generateInfo("tab.thermalexpansion.machine.precipitator");
        this.myTile = (TilePrecipitator)tile;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.slotInput = this.addElement(new ElementSlotOverlay(this, 44, 19).setSlotInfo(ElementSlotOverlay.SlotColor.BLUE, ElementSlotOverlay.SlotType.TANK_SHORT, ElementSlotOverlay.SlotRender.FULL));
        this.slotOutput = this.addElement(new ElementSlotOverlay(this, 130, 22).setSlotInfo(ElementSlotOverlay.SlotColor.ORANGE, ElementSlotOverlay.SlotType.OUTPUT, ElementSlotOverlay.SlotRender.FULL));
        if (!this.myTile.smallStorage()) {
            this.addElement((ElementBase)new ElementEnergyStored((GuiContainerCore)this, 8, 8, this.myTile.getEnergyStorage()));
        }
        this.addElement((ElementBase)new ElementFluidTank((GuiContainerCore)this, 44, 19, (IFluidTank)this.myTile.getTank()).setAlwaysShow(true).setSmall());
        this.progressFluid = (ElementFluid)this.addElement(new ElementFluid((GuiContainerCore)this, 85, 26).setFluid(this.myTile.getTankFluid()).setSize(24, 16));
        this.progressOverlay = (ElementDualScaled)this.addElement(new ElementDualScaled((GuiContainerCore)this, 85, 26).setMode(1).setBackground(false).setSize(24, 16).setTexture("cofh:textures/gui/elements/progress_fluid_right.png", 64, 16));
        this.speed = (ElementDualScaled)this.addElement(new ElementDualScaled((GuiContainerCore)this, 44, 53).setSize(16, 16).setTexture("cofh:textures/gui/elements/scale_snowflake.png", 32, 16));
        this.prevOutput = new ElementButton((GuiContainerCore)this, 72, 54, "PrevOutput", 176, 0, 176, 14, 176, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.nextOutput = new ElementButton((GuiContainerCore)this, 108, 54, "NextOutput", 190, 0, 190, 14, 190, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.addElement((ElementBase)this.prevOutput);
        this.addElement((ElementBase)this.nextOutput);
    }

    protected void updateElementInformation() {
        super.updateElementInformation();
        this.slotInput.setVisible(this.myTile.hasSideType(1) || this.baseTile.hasSideType(8));
        this.slotOutput.setVisible(this.myTile.hasSideType(4) || this.baseTile.hasSideType(8));
        this.progressFluid.setSize(this.myTile.getScaledProgress(24), 16);
        this.progressOverlay.setQuantity(this.myTile.getScaledProgress(24));
        this.speed.setQuantity(this.myTile.getScaledSpeed(16));
    }

    public void handleElementButtonClick(String buttonName, int mouseButton) {
        byte direction = 0;
        float pitch = 0.7f;
        if (buttonName.equalsIgnoreCase("PrevOutput")) {
            direction = (byte)(direction - 1);
            pitch -= 0.1f;
        } else if (buttonName.equalsIgnoreCase("NextOutput")) {
            pitch += 0.1f;
            direction = (byte)(direction + 1);
        }
        GuiPrecipitator.playClickSound((float)pitch);
        this.myTile.setMode(direction);
    }
}

