/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.multiblock;

import cofh.repack.codechicken.lib.vec.BlockCoord;
import cofh.thermaldynamics.multiblock.IMultiBlockRoute;
import gnu.trove.iterator.TByteIterator;
import gnu.trove.list.TByteList;
import gnu.trove.list.linked.TByteLinkedList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Route
implements Comparable<Route> {
    public TByteLinkedList pathDirections = new TByteLinkedList();
    public IMultiBlockRoute endPoint;
    public int pathWeight = 0;
    public boolean routeFinished = false;
    public BlockCoord dest;
    public static final byte[] tmpBuffer = new byte[256];

    public Route(IMultiBlockRoute iMultiBlockRoute) {
        this.endPoint = iMultiBlockRoute;
    }

    public Route(Route route, IMultiBlockRoute iMultiBlockRoute, byte by, boolean bl) {
        this.pathDirections = new TByteLinkedList((TByteList)route.pathDirections);
        this.pathWeight = route.pathWeight + iMultiBlockRoute.getWeight();
        this.endPoint = iMultiBlockRoute;
        this.pathDirections.add(by);
        this.routeFinished = bl;
    }

    public Route(Route route, boolean bl) {
        this.pathDirections = new TByteLinkedList((TByteList)route.pathDirections);
        this.pathWeight = route.pathWeight;
        this.endPoint = route.endPoint;
        this.routeFinished = true;
    }

    public Route(Route route) {
        this.pathDirections = new TByteLinkedList((TByteList)route.pathDirections);
        this.pathWeight = route.pathWeight;
        this.endPoint = route.endPoint;
        this.routeFinished = route.routeFinished;
    }

    @Override
    public int compareTo(Route route) {
        if (this.pathWeight < route.pathWeight) {
            return -1;
        }
        if (this.pathWeight > route.pathWeight) {
            return 1;
        }
        if (this.pathDirections.size() < route.pathDirections.size()) {
            return -1;
        }
        if (this.pathDirections.size() > route.pathDirections.size()) {
            return 1;
        }
        return 0;
    }

    public Route copy() {
        return new Route(this);
    }

    public byte getNextDirection() {
        return this.pathDirections.removeAt(0);
    }

    public boolean hasNextDirection() {
        return this.pathDirections.size() > 0;
    }

    public int getCurrentDirection() {
        return this.pathDirections.get(0);
    }

    public int checkNextDirection() {
        return this.pathDirections.get(1);
    }

    public int getLastSide() {
        return this.pathDirections.size() > 0 ? (int)this.pathDirections.get(this.pathDirections.size() - 1) : 0;
    }

    public Route(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            byte[] byArray2;
            if (byteArrayInputStream.read() == 0) {
                byArray2 = new byte[byteArrayInputStream.available()];
                byteArrayInputStream.read(byArray2);
            } else {
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
                while ((n = gZIPInputStream.read(tmpBuffer)) >= 0) {
                    byteArrayOutputStream.write(tmpBuffer, 0, n);
                }
                gZIPInputStream.close();
                byArray2 = byteArrayOutputStream.toByteArray();
            }
            for (Object object : (ByteArrayOutputStream)byArray2) {
                byte by;
                byte by2 = (byte)(object & 7);
                if (by2 < 6) {
                    this.pathDirections.add(by2);
                }
                if ((by = (byte)(object >> 3)) >= 6) continue;
                this.pathDirections.add(by);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[(this.pathDirections.size() + 1) / 2];
        int n = 0;
        TByteIterator tByteIterator = this.pathDirections.iterator();
        while (tByteIterator.hasNext()) {
            byArray[n] = tByteIterator.next();
            if (tByteIterator.hasNext()) {
                int n2 = n;
                byArray[n2] = (byte)(byArray[n2] | tByteIterator.next() << 3);
            } else {
                int n3 = n;
                byArray[n3] = (byte)(byArray[n3] | 0x30);
            }
            ++n;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (byArray.length <= 20) {
                byteArrayOutputStream.write(0);
                byteArrayOutputStream.write(byArray);
            } else {
                byteArrayOutputStream.write(1);
                GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                gZIPOutputStream.write(byArray);
                gZIPOutputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }
}

