/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.fluid;

import cofh.core.network.PacketHandler;
import cofh.lib.util.TimeTracker;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.position.ChunkCoord;
import cofh.thermaldynamics.duct.fluid.FluidGridSuper;
import cofh.thermaldynamics.duct.fluid.FluidTankGrid;
import cofh.thermaldynamics.duct.fluid.PacketFluid;
import cofh.thermaldynamics.duct.fluid.TileFluidDuct;
import cofh.thermaldynamics.multiblock.IMultiBlock;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import cofh.thermaldynamics.multiblock.MultiBlockGridTracking;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.FluidStack;

public class FluidGrid
extends MultiBlockGridTracking {
    public final FluidTankGrid myTank = new FluidTankGrid(1000, this);
    public int toDistribute = 0;
    public HashSet<ChunkCoord> chunks;
    TimeTracker myTracker = new TimeTracker();
    boolean recentRenderUpdate = false;
    int renderFluidLevel = 0;
    FluidStack myRenderFluid = null;
    public boolean doesPassiveTicking = false;

    public FluidGrid(World world) {
        super(world);
    }

    @Override
    public void onMajorGridChange() {
        super.onMajorGridChange();
        this.chunks = null;
    }

    @Override
    public void onMinorGridChange() {
        super.onMinorGridChange();
    }

    @Override
    public int getLevel() {
        return this.myTank.getFluidAmount();
    }

    @Override
    public void addBlock(IMultiBlock iMultiBlock) {
        super.addBlock(iMultiBlock);
        TileFluidDuct tileFluidDuct = (TileFluidDuct)iMultiBlock;
        if (tileFluidDuct.fluidForGrid != null) {
            if (this.myTank.getFluid() == null) {
                this.myTank.setFluid(tileFluidDuct.fluidForGrid);
            } else {
                this.myTank.fill(tileFluidDuct.fluidForGrid, true);
            }
            tileFluidDuct.fluidForGrid = null;
            this.recentRenderUpdate = true;
        }
        if (this.renderFluidLevel != 0) {
            tileFluidDuct.updateFluid();
        }
    }

    @Override
    public void balanceGrid() {
        this.myTank.setCapacity(this.size() * this.myTank.fluidPerDuct);
    }

    public float getThroughPutModifier() {
        return 1.0f;
    }

    public int getMaxFluidPerDuct() {
        return 3000;
    }

    @Override
    public void destroyNode(IMultiBlock iMultiBlock) {
        if (this.hasValidFluid()) {
            ((TileFluidDuct)iMultiBlock).fluidForGrid = this.getNodeShare((TileFluidDuct)iMultiBlock);
        }
        super.destroyNode(iMultiBlock);
    }

    @Override
    public boolean canAddBlock(IMultiBlock iMultiBlock) {
        return iMultiBlock instanceof TileFluidDuct && FluidHelper.isFluidEqualOrNull((FluidStack)((TileFluidDuct)iMultiBlock).getConnectionFluid(), (FluidStack)this.myTank.getFluid());
    }

    @Override
    public void tickGrid() {
        block11: {
            super.tickGrid();
            if (this.worldGrid.worldObj.func_82737_E() % 4L == 0L) {
                this.updateAllRenders();
            }
            if (this.myTank.getFluid() != null && this.nodeSet.size() > 0) {
                this.toDistribute = Math.min(this.myTank.getFluidAmount() / this.size(), this.getFluidThroughput());
                if (this.toDistribute <= 0) {
                    this.toDistribute = Math.min(this.myTank.getFluidAmount() % this.size(), this.getFluidThroughput());
                }
                if (this.toDistribute > 0) {
                    for (IMultiBlock iMultiBlock : this.nodeSet) {
                        if (!iMultiBlock.tickPass(0) || iMultiBlock.getGrid() == null) break;
                    }
                }
            }
            if (!this.nodeSet.isEmpty()) {
                for (IMultiBlock iMultiBlock : this.nodeSet) {
                    if (!iMultiBlock.tickPass(1) || iMultiBlock.getGrid() == null) break;
                }
            }
            if (!this.doesPassiveTicking) break block11;
            if (!this.nodeSet.isEmpty()) {
                for (IMultiBlock iMultiBlock : this.nodeSet) {
                    if (!iMultiBlock.tickPass(2) || iMultiBlock.getGrid() == null) break;
                }
            }
            if (!this.idleSet.isEmpty()) {
                for (IMultiBlock iMultiBlock : this.idleSet) {
                    if (!iMultiBlock.tickPass(2) || iMultiBlock.getGrid() == null) break;
                }
            }
        }
    }

    @Override
    public void mergeGrids(MultiBlockGrid multiBlockGrid) {
        super.mergeGrids(multiBlockGrid);
        FluidGrid fluidGrid = (FluidGrid)multiBlockGrid;
        this.doesPassiveTicking = this.doesPassiveTicking || fluidGrid.doesPassiveTicking;
        this.myTank.fill(fluidGrid.getFluid(), true);
        this.recentRenderUpdate = true;
    }

    @Override
    public boolean canGridsMerge(MultiBlockGrid multiBlockGrid) {
        return super.canGridsMerge(multiBlockGrid) && FluidHelper.isFluidEqualOrNull((FluidStack)((FluidGrid)multiBlockGrid).getFluid(), (FluidStack)this.getFluid());
    }

    public int getFluidThroughput() {
        if (this.myTank.getFluid() == null) {
            return 100;
        }
        int n = this.myTank.getCapacity();
        if (this.myTank.getFluid().amount >= n * 3 / 4) {
            return this.myTank.fluidThroughput;
        }
        if (this.myTank.getFluid().amount <= n / 4) {
            return this.myTank.fluidThroughput >> 1;
        }
        return (this.myTank.fluidThroughput >> 1) + (this.myTank.fluidThroughput >> 1) * (this.myTank.getFluid().amount - (n >> 2)) / (n >> 1);
    }

    public void fluidChanged() {
        this.balanceGrid();
    }

    public FluidStack getNodeShare(TileFluidDuct tileFluidDuct) {
        FluidStack fluidStack = this.myTank.getFluid().copy();
        fluidStack.amount = this.getNodeAmount(tileFluidDuct);
        return fluidStack;
    }

    public int getNodeAmount(TileFluidDuct tileFluidDuct) {
        return this.size() == 1 ? this.myTank.getFluidAmount() : (this.isFirstMultiblock(tileFluidDuct) ? this.myTank.getFluidAmount() / this.size() + this.myTank.getFluidAmount() % this.size() : this.myTank.getFluidAmount() / this.size());
    }

    public FluidStack getFluid() {
        return this.myTank.getFluid();
    }

    public boolean hasValidFluid() {
        return this.myTank.getFluid() != null;
    }

    public void buildMap() {
        this.chunks = new HashSet();
        for (IMultiBlock iMultiBlock : Iterables.concat(this.nodeSet, this.idleSet)) {
            this.buildMapEntry(iMultiBlock);
        }
    }

    private void buildMapEntry(IMultiBlock iMultiBlock) {
        this.chunks.add(new ChunkCoord(iMultiBlock.x() >> 4, iMultiBlock.z() >> 4));
    }

    public void updateAllRenders() {
        int n = this.renderFluidLevel;
        if (this.updateRender() && n != this.renderFluidLevel) {
            if (this.myTank.getFluid() != null) {
                this.myRenderFluid = this.myTank.getFluid().copy();
                this.myRenderFluid.amount = this.renderFluidLevel;
            } else {
                this.myRenderFluid = null;
            }
            if (this.chunks == null) {
                this.buildMap();
            }
            if (this.worldGrid.worldObj instanceof WorldServer) {
                int n2 = 0;
                for (Object object : Iterables.concat(this.nodeSet, this.idleSet)) {
                    TileFluidDuct tileFluidDuct = (TileFluidDuct)object;
                    if (tileFluidDuct.getDuctType().opaque) continue;
                    ++n2;
                    tileFluidDuct.updateLighting();
                }
                if (n2 != 0) {
                    Object object;
                    Object object2 = new PacketFluid(this, n2);
                    object = (WorldServer)this.worldGrid.worldObj;
                    block1: for (EntityPlayerMP entityPlayerMP : ((World)object).field_73010_i) {
                        for (ChunkCoord chunkCoord : this.chunks) {
                            int n3;
                            int n4 = (chunkCoord.chunkX - (MathHelper.floor((double)entityPlayerMP.field_70165_t) >> 4)) * 16;
                            if (n4 * n4 + (n3 = (chunkCoord.chunkZ - (MathHelper.floor((double)entityPlayerMP.field_70161_v) >> 4)) * 16) * n3 > 36864) continue;
                            PacketHandler.sendTo(object2, (EntityPlayerMP)entityPlayerMP);
                            continue block1;
                        }
                    }
                }
            }
        }
    }

    public boolean updateRender() {
        if (this.recentRenderUpdate && this.myTracker.hasDelayPassed(this.worldGrid.worldObj, 96)) {
            this.recentRenderUpdate = false;
        }
        if (this.myTank.getFluid() != null && this.myTank.getCapacity() > 0) {
            double d = 10000 * this.myTank.getFluid().amount / this.myTank.getCapacity();
            if (d >= 0.0) {
                int n = this.renderFluidLevel == 2 ? 500 : 700;
                if (d <= (double)n) {
                    this.renderFluidLevel = 1;
                    return true;
                }
            }
            if (d >= 500.0) {
                int n = this.renderFluidLevel == 3 ? 2000 : 2500;
                if (d <= (double)n) {
                    this.renderFluidLevel = 2;
                    return true;
                }
            }
            if (d >= 2000.0) {
                int n = this.renderFluidLevel == 4 ? 4000 : 4500;
                if (d <= (double)n) {
                    this.renderFluidLevel = 3;
                    return true;
                }
            }
            if (d >= 4000.0) {
                int n = this.renderFluidLevel == 5 ? 6000 : 6500;
                if (d <= (double)n) {
                    this.renderFluidLevel = 4;
                    return true;
                }
            }
            if (d >= 6000.0) {
                int n = this.renderFluidLevel == 6 ? 8000 : 8500;
                if (d <= (double)n) {
                    this.renderFluidLevel = 5;
                    return true;
                }
            }
            this.renderFluidLevel = 6;
            return true;
        }
        if (this.renderFluidLevel != 0 && !this.recentRenderUpdate) {
            this.renderFluidLevel = 0;
            this.recentRenderUpdate = true;
            this.myTracker.markTime(this.worldGrid.worldObj);
            return true;
        }
        return false;
    }

    public FluidStack getRenderFluid() {
        return this.myRenderFluid;
    }

    public FluidStack getConnectionFluid() {
        int n = this.renderFluidLevel;
        if (this.updateRender() && n != this.renderFluidLevel) {
            if (this.myTank.getFluid() != null) {
                this.myRenderFluid = this.myTank.getFluid().copy();
                this.myRenderFluid.amount = this.renderFluidLevel;
            } else {
                this.myRenderFluid = null;
            }
        }
        return this.myRenderFluid;
    }

    public int getRenderLevel() {
        return this.renderFluidLevel;
    }

    @Override
    public void addInfo(List<IChatComponent> list, EntityPlayer entityPlayer, boolean bl) {
        super.addInfo(list, entityPlayer, bl);
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null) {
            if (this instanceof FluidGridSuper) {
                this.addInfo(list, "fluidThroughput", new ChatComponentTranslation("info.thermaldynamics.filter.zeroRetainSize", new Object[0]));
            } else {
                this.addInfo(list, "fluidThroughput", this.myTank.fluidThroughput);
            }
        }
    }

    @Override
    protected String getUnit() {
        return "mB";
    }

    public static final class FluidRenderType {
        public static final byte EMPTY = 0;
        public static final byte LOW = 1;
        public static final byte LOW_MED = 2;
        public static final byte MEDIUM = 3;
        public static final byte MED_HIGH = 4;
        public static final byte HIGH = 5;
        public static final byte FULL = 6;
    }
}

