/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.entity;

import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.entity.EntityTransport;
import cofh.thermaldynamics.duct.entity.TileTransportDuctBase;
import cofh.thermaldynamics.duct.entity.TransportGrid;
import cofh.thermaldynamics.duct.item.TileItemDuct;
import cofh.thermaldynamics.multiblock.IMultiBlock;
import cofh.thermaldynamics.multiblock.IMultiBlockRoute;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import cofh.thermaldynamics.multiblock.Route;
import cofh.thermaldynamics.multiblock.RouteCache;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class TileTransportDuctBaseRoute
extends TileTransportDuctBase
implements IMultiBlockRoute {
    public TransportGrid internalGrid;

    @Override
    public void setGrid(MultiBlockGrid multiBlockGrid) {
        super.setGrid(multiBlockGrid);
        this.internalGrid = (TransportGrid)multiBlockGrid;
    }

    @Override
    public MultiBlockGrid getNewGrid() {
        return new TransportGrid(((TileEntity)this).field_145850_b);
    }

    public RouteCache getCache() {
        return this.getCache(true);
    }

    public RouteCache getCache(boolean bl) {
        return bl ? this.internalGrid.getRoutesFromOutput(this) : this.internalGrid.getRoutesFromOutputNonUrgent(this);
    }

    public Route getRoute(Entity entity, int n, byte by) {
        if (entity == null || entity.field_70128_L) {
            return null;
        }
        for (Route route : this.getCache().outputRoutes) {
            if (route.endPoint == this || !route.endPoint.isOutput()) continue;
            Route route2 = route.copy();
            byte by2 = route.endPoint.getStuffedSide();
            route2.pathDirections.add(by2);
            return route2;
        }
        return null;
    }

    public EntityTransport findRoute(Entity entity, int n, byte by) {
        Route route = this.getRoute(entity, n, by);
        return route != null ? new EntityTransport(this, route, (byte)n, by) : null;
    }

    @Override
    public int getWeight() {
        return 1;
    }

    @Override
    public boolean canStuffItem() {
        return false;
    }

    @Override
    public boolean isOutput() {
        return false;
    }

    @Override
    public int getMaxRange() {
        return Integer.MAX_VALUE;
    }

    @Override
    public TileTDBase.NeighborTypes getCachedSideType(byte by) {
        return this.neighborTypes[by];
    }

    @Override
    public TileTDBase.ConnectionTypes getConnectionType(byte by) {
        return this.connectionTypes[by];
    }

    @Override
    public IMultiBlock getCachedTile(byte by) {
        return this.neighborMultiBlocks[by];
    }

    @Override
    public TileItemDuct.RouteInfo canRouteItem(ItemStack itemStack) {
        return TileItemDuct.noRoute;
    }

    @Override
    public byte getStuffedSide() {
        for (byte by = 0; by < 6; by = (byte)(by + 1)) {
            if (this.neighborTypes[by] != TileTDBase.NeighborTypes.OUTPUT) continue;
            return by;
        }
        return 0;
    }

    @Override
    public boolean acceptingStuff() {
        return false;
    }

    @Override
    public boolean advanceEntity(EntityTransport entityTransport) {
        entityTransport.progress = (byte)(entityTransport.progress + entityTransport.step);
        if (entityTransport.myPath == null) {
            entityTransport.bouncePassenger(this);
        } else if (entityTransport.progress >= 100) {
            entityTransport.progress = (byte)(entityTransport.progress % 100);
            this.advanceToNextTile(entityTransport);
        } else if (entityTransport.progress >= 50 && entityTransport.progress - entityTransport.step < 50 && (entityTransport.reRoute || this.neighborTypes[entityTransport.direction] == TileTDBase.NeighborTypes.NONE)) {
            entityTransport.bouncePassenger(this);
        }
        return false;
    }

    public void advanceToNextTile(EntityTransport entityTransport) {
        entityTransport.advanceTile(this);
    }

    @Override
    public boolean isConnectable(TileEntity tileEntity, int n) {
        return tileEntity instanceof TileTransportDuctBaseRoute;
    }
}

