/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.items;

import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import squeek.veganoption.ModInfo;
import squeek.veganoption.helpers.BlockHelper;
import squeek.veganoption.helpers.FluidHelper;

public class ItemWashableWheat
extends Item {
    public static IIcon flourIcon;
    public static IIcon doughIcon;
    public static IIcon partiallyWashedIcon;
    public static IIcon fullyWashedIcon;
    public static final int META_FLOUR = 0;
    public static final int META_DOUGH = 1;
    public static final int META_UNWASHED_START = 2;
    public static final int NUM_WASHES_NEEDED = 4;
    public static final int META_UNWASHED_END = 6;
    public static final int META_RAW = 6;

    public ItemWashableWheat() {
        this.func_77627_a(true);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        ItemWashableWheat.tryWash(entityItem);
        return super.onEntityItemUpdate(entityItem);
    }

    public static boolean isReadyToCook(ItemStack itemStack) {
        return ItemWashableWheat.getPercentWashed(itemStack) >= 1.0f;
    }

    public static boolean isUnwashed(ItemStack itemStack) {
        int meta = itemStack.func_77960_j();
        return meta >= 2 && meta < 6;
    }

    public static ItemStack wash(ItemStack itemStack, int amount) {
        int newMeta = Math.min(6, itemStack.func_77960_j() + amount);
        itemStack.func_77964_b(newMeta);
        return itemStack;
    }

    public static float getPercentWashed(ItemStack itemStack) {
        return (float)(itemStack.func_77960_j() - 2) / 4.0f;
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        return ItemWashableWheat.isUnwashed(itemStack);
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        return 1.0f - ItemWashableWheat.getPercentWashed(itemStack);
    }

    public static boolean tryWash(EntityItem entityItem) {
        BlockHelper.BlockPos fluidBlockPos;
        FluidStack consumedFluid;
        if (entityItem == null || entityItem.field_70170_p.field_72995_K || entityItem.func_92059_d() == null) {
            return false;
        }
        if (!ItemWashableWheat.isReadyToCook(entityItem.func_92059_d()) && (consumedFluid = FluidHelper.consumeExactFluid(fluidBlockPos = BlockHelper.blockPos(entityItem.field_70170_p, MathHelper.func_76128_c((double)entityItem.field_70165_t), MathHelper.func_76128_c((double)entityItem.field_70163_u), MathHelper.func_76128_c((double)entityItem.field_70161_v)), FluidRegistry.WATER, 1000)) != null) {
            EntityItem entityItemToWash = entityItem;
            ItemStack doughToWash = entityItemToWash.func_92059_d();
            if (entityItemToWash.func_92059_d().field_77994_a > 1) {
                doughToWash = entityItem.func_92059_d().func_77979_a(1);
                entityItemToWash = new EntityItem(entityItemToWash.field_70170_p, entityItemToWash.field_70165_t, entityItemToWash.field_70163_u, entityItemToWash.field_70161_v, doughToWash);
                entityItemToWash.field_145804_b = 10;
                entityItemToWash.field_70170_p.func_72838_d((Entity)entityItemToWash);
            }
            ItemStack washedItemStack = ItemWashableWheat.wash(doughToWash, 1);
            entityItemToWash.func_92058_a(washedItemStack);
            return true;
        }
        return false;
    }

    public String func_77667_c(ItemStack itemStack) {
        String baseName = super.func_77667_c(itemStack);
        switch (itemStack.func_77960_j()) {
            case 0: {
                return baseName + ".wheatFlour";
            }
            case 1: {
                return baseName + ".wheatDough";
            }
            case 6: {
                return baseName + ".seitanRaw";
            }
        }
        return baseName + ".seitanRawUnwashed";
    }

    public IIcon func_77617_a(int meta) {
        switch (meta) {
            case 0: {
                return flourIcon;
            }
            case 1: {
                return doughIcon;
            }
            case 6: {
                return fullyWashedIcon;
            }
        }
        return partiallyWashedIcon;
    }

    public void func_94581_a(IIconRegister iconRegister) {
        flourIcon = iconRegister.func_94245_a(ModInfo.MODID_LOWER + ":wheat_flour");
        doughIcon = iconRegister.func_94245_a(ModInfo.MODID_LOWER + ":wheat_dough");
        partiallyWashedIcon = iconRegister.func_94245_a(ModInfo.MODID_LOWER + ":seitan_raw_unwashed");
        fullyWashedIcon = iconRegister.func_94245_a(ModInfo.MODID_LOWER + ":seitan_raw");
    }

    public void func_150895_a(Item item, CreativeTabs creativeTab, List subItems) {
        subItems.add(new ItemStack(item, 1, 0));
        subItems.add(new ItemStack(item, 1, 1));
        subItems.add(new ItemStack(item, 1, 2));
        subItems.add(new ItemStack(item, 1, 6));
    }
}

