/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.items;

import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionHelper;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import squeek.veganoption.ModInfo;
import squeek.veganoption.content.modules.Ender;
import squeek.veganoption.helpers.BlockHelper;
import squeek.veganoption.helpers.FluidHelper;

public class ItemFrozenBubble
extends Item {
    public static IIcon partiallyFilledIcon;

    public ItemFrozenBubble() {
        this.func_77627_a(true);
    }

    public String func_150896_i(ItemStack itemStack) {
        return PotionHelper.field_151423_m;
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        ItemFrozenBubble.tryFillWithRawEnderFromWorld(entityItem);
        return super.onEntityItemUpdate(entityItem);
    }

    public static boolean isFull(ItemStack itemStack) {
        return ItemFrozenBubble.getPercentFilled(itemStack) >= 1.0f;
    }

    public static boolean isEmpty(ItemStack itemStack) {
        return ItemFrozenBubble.getPercentFilled(itemStack) <= 0.0f;
    }

    public static ItemStack fill(ItemStack itemStack, int amount) {
        itemStack.func_77964_b(itemStack.func_77960_j() + amount);
        if (ItemFrozenBubble.isFull(itemStack)) {
            return new ItemStack(Items.field_151079_bi);
        }
        return itemStack;
    }

    public static float getPercentFilled(ItemStack itemStack) {
        return (float)itemStack.func_77960_j() / 8.0f;
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        return !ItemFrozenBubble.isEmpty(itemStack);
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        return 1.0f - ItemFrozenBubble.getPercentFilled(itemStack);
    }

    public static boolean tryFillWithRawEnderFromWorld(EntityItem entityItem) {
        BlockHelper.BlockPos fluidBlockPos;
        FluidStack consumedFluid;
        if (entityItem == null || entityItem.field_70170_p.field_72995_K || entityItem.func_92059_d() == null) {
            return false;
        }
        if (!ItemFrozenBubble.isFull(entityItem.func_92059_d()) && (consumedFluid = FluidHelper.consumeExactFluid(fluidBlockPos = BlockHelper.blockPos(entityItem.field_70170_p, MathHelper.func_76128_c((double)entityItem.field_70165_t), MathHelper.func_76128_c((double)entityItem.field_70163_u), MathHelper.func_76128_c((double)entityItem.field_70161_v)), Ender.fluidRawEnder, 125)) != null) {
            EntityItem entityItemToFill = entityItem;
            ItemStack bubbleToFill = entityItemToFill.func_92059_d();
            if (entityItemToFill.func_92059_d().field_77994_a > 1) {
                bubbleToFill = entityItem.func_92059_d().func_77979_a(1);
                entityItemToFill = new EntityItem(entityItemToFill.field_70170_p, entityItemToFill.field_70165_t, entityItemToFill.field_70163_u, entityItemToFill.field_70161_v, bubbleToFill);
                entityItemToFill.field_145804_b = 10;
                entityItemToFill.field_70170_p.func_72838_d((Entity)entityItemToFill);
            }
            ItemStack filledItemStack = ItemFrozenBubble.fill(bubbleToFill, 1);
            entityItemToFill.func_92058_a(filledItemStack);
            return true;
        }
        return false;
    }

    public String func_77667_c(ItemStack itemStack) {
        return super.func_77667_c(itemStack) + (!ItemFrozenBubble.isEmpty(itemStack) ? "Filled" : "");
    }

    public IIcon func_77617_a(int meta) {
        return meta > 0 ? partiallyFilledIcon : super.func_77617_a(meta);
    }

    public void func_94581_a(IIconRegister iconRegister) {
        super.func_94581_a(iconRegister);
        partiallyFilledIcon = iconRegister.func_94245_a(ModInfo.MODID_LOWER + ":frozen_bubble_filled");
    }
}

