/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public abstract class ContainerGeneric
extends Container {
    protected IInventory inventory;
    protected int nextSlotIndex = 0;
    protected boolean allowShiftClickToMultipleSlots = false;

    public ContainerGeneric(IInventory inventory) {
        this.inventory = inventory;
        this.onContainerOpened();
    }

    protected void addSlot(IInventory inventory, int xStart, int yStart) {
        this.addSlotOfType(Slot.class, inventory, xStart, yStart);
    }

    protected void addSlots(IInventory inventory, int xStart, int yStart) {
        this.addSlotsOfType(Slot.class, inventory, xStart, yStart, 1);
    }

    protected void addSlots(IInventory inventory, int xStart, int yStart, int rows) {
        this.addSlotsOfType(Slot.class, inventory, xStart, yStart, rows);
    }

    protected void addSlots(IInventory inventory, int xStart, int yStart, int numSlots, int rows) {
        this.addSlotsOfType(Slot.class, inventory, xStart, yStart, numSlots, rows);
    }

    protected void addSlotOfType(Class<? extends Slot> slotClass, IInventory inventory, int xStart, int yStart) {
        this.addSlotsOfType(slotClass, inventory, xStart, yStart, 1, 1);
    }

    protected void addSlotsOfType(Class<? extends Slot> slotClass, IInventory inventory, int xStart, int yStart) {
        this.addSlotsOfType(slotClass, inventory, xStart, yStart, inventory.func_70302_i_(), 1);
    }

    protected void addSlotsOfType(Class<? extends Slot> slotClass, IInventory inventory, int xStart, int yStart, int rows) {
        this.addSlotsOfType(slotClass, inventory, xStart, yStart, inventory.func_70302_i_(), rows);
    }

    protected void addSlotsOfType(Class<? extends Slot> slotClass, IInventory inventory, int xStart, int yStart, int numSlots, int rows) {
        int numSlotsPerRow = numSlots / rows;
        int i = 0;
        int col = 0;
        int row = 0;
        while (i < numSlots) {
            if (col >= numSlotsPerRow) {
                ++row;
                col = 0;
            }
            try {
                this.func_75146_a(slotClass.getConstructor(IInventory.class, Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(inventory, this.getNextSlotIndex(), xStart + col * 18, yStart + row * 18));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
            ++col;
        }
    }

    protected int getNextSlotIndex() {
        ++this.nextSlotIndex;
        return this.nextSlotIndex - 1;
    }

    protected void addPlayerInventorySlots(InventoryPlayer playerInventory, int yStart) {
        this.addPlayerInventorySlots(playerInventory, 8, yStart);
    }

    protected void addPlayerInventorySlots(InventoryPlayer playerInventory, int xStart, int yStart) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)playerInventory, col + row * 9 + 9, xStart + col * 18, yStart + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)playerInventory, col, xStart + col * 18, yStart + 58));
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotNum) {
        Slot slot = (Slot)this.field_75151_b.get(slotNum);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot;
            ItemStack stackToTransfer = stackInSlot = slot.func_75211_c();
            if (slotNum < this.inventory.func_70302_i_() ? !this.func_75135_a(stackToTransfer, this.inventory.func_70302_i_(), this.field_75151_b.size(), true) : !this.func_75135_a(stackToTransfer, 0, this.inventory.func_70302_i_(), false)) {
                return null;
            }
            if (stackToTransfer.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (this.allowShiftClickToMultipleSlots) {
                return stackToTransfer;
            }
        }
        return null;
    }

    public int getEffectiveMaxStackSizeForSlot(int slotNum, ItemStack itemStack) {
        int effectiveMaxStackSize = itemStack.func_77976_d();
        if (slotNum < this.inventory.func_70302_i_()) {
            effectiveMaxStackSize = Math.min(effectiveMaxStackSize, this.inventory.func_70297_j_());
        }
        return effectiveMaxStackSize;
    }

    protected boolean func_75135_a(ItemStack itemStack, int startSlotNum, int endSlotNum, boolean checkBackwards) {
        ItemStack itemstack1;
        Slot slot;
        boolean didMerge = false;
        int k = startSlotNum;
        if (checkBackwards) {
            k = endSlotNum - 1;
        }
        if (itemStack.func_77985_e()) {
            while (itemStack.field_77994_a > 0 && (!checkBackwards && k < endSlotNum || checkBackwards && k >= startSlotNum)) {
                slot = (Slot)this.field_75151_b.get(k);
                itemstack1 = slot.func_75211_c();
                if (itemstack1 != null && itemstack1.func_77973_b() == itemStack.func_77973_b() && (!itemStack.func_77981_g() || itemStack.func_77960_j() == itemstack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)itemstack1) && slot.func_75214_a(itemStack)) {
                    int l = itemstack1.field_77994_a + itemStack.field_77994_a;
                    int effectiveMaxStackSize = this.getEffectiveMaxStackSizeForSlot(k, itemStack);
                    if (l <= effectiveMaxStackSize) {
                        itemStack.field_77994_a = 0;
                        itemstack1.field_77994_a = l;
                        slot.func_75218_e();
                        didMerge = true;
                        break;
                    }
                    if (itemstack1.field_77994_a < effectiveMaxStackSize) {
                        itemStack.field_77994_a -= effectiveMaxStackSize - itemstack1.field_77994_a;
                        itemstack1.field_77994_a = effectiveMaxStackSize;
                        slot.func_75218_e();
                        didMerge = true;
                        break;
                    }
                }
                if (checkBackwards) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        if (itemStack.field_77994_a > 0) {
            k = checkBackwards ? endSlotNum - 1 : startSlotNum;
            while (!checkBackwards && k < endSlotNum || checkBackwards && k >= startSlotNum) {
                slot = (Slot)this.field_75151_b.get(k);
                itemstack1 = slot.func_75211_c();
                if (itemstack1 == null && slot.func_75214_a(itemStack)) {
                    int effectiveMaxStackSize = this.getEffectiveMaxStackSizeForSlot(k, itemStack);
                    ItemStack transferedStack = itemStack.func_77946_l();
                    if (transferedStack.field_77994_a > effectiveMaxStackSize) {
                        transferedStack.field_77994_a = effectiveMaxStackSize;
                    }
                    slot.func_75215_d(transferedStack);
                    slot.func_75218_e();
                    itemStack.field_77994_a -= transferedStack.field_77994_a;
                    didMerge = true;
                    break;
                }
                if (checkBackwards) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        return didMerge;
    }

    public ItemStack func_75144_a(int slotNum, int mouseButton, int modifier, EntityPlayer player) {
        return super.func_75144_a(slotNum, mouseButton, modifier, player);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public void onContainerOpened() {
        this.inventory.func_70295_k_();
    }

    public void func_75134_a(EntityPlayer player) {
        this.inventory.func_70305_f();
        super.func_75134_a(player);
    }
}

