/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.inventory;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import invtweaks.api.container.ChestContainer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import squeek.veganoption.blocks.tiles.TileEntityComposter;
import squeek.veganoption.inventory.ContainerGeneric;
import squeek.veganoption.inventory.SlotFiltered;

@ChestContainer
public class ContainerComposter
extends ContainerGeneric {
    public TileEntityComposter composter;
    public int slotsX;
    public int slotsY;
    private boolean initialUpdate = true;
    public byte lastPercentComposted = 0;
    public byte lastBiomeTemperature = 0;
    public long lastAeration = 0L;
    public static final int PROGRESS_ID_PERCENT_COMPOSTED = 1;
    public static final int PROGRESS_ID_BIOME_TEMPERATURE = 2;

    public ContainerComposter(InventoryPlayer playerInventory, TileEntityComposter composter) {
        super(composter);
        this.composter = composter;
        this.allowShiftClickToMultipleSlots = true;
        this.slotsX = 8;
        this.slotsY = 18;
        this.addSlotsOfType(SlotFiltered.class, composter, this.slotsX, this.slotsY, 3);
        this.addPlayerInventorySlots(playerInventory, 85);
    }

    public void func_75142_b() {
        if (this.initialUpdate) {
            this.lastAeration = this.composter.lastAeration;
        } else if (this.lastAeration != this.composter.lastAeration) {
            for (Object crafter : this.field_75149_d) {
                if (!(crafter instanceof EntityPlayerMP)) continue;
                ((EntityPlayerMP)crafter).field_71137_h = false;
            }
            this.lastAeration = this.composter.lastAeration;
        }
        super.func_75142_b();
        if ((byte)(this.composter.getCompostingPercent() * 100.0f) != this.lastPercentComposted || this.initialUpdate) {
            for (Object crafter : this.field_75149_d) {
                ((ICrafting)crafter).func_71112_a((Container)this, 1, (int)((byte)(this.composter.getCompostingPercent() * 100.0f)));
            }
            this.lastPercentComposted = (byte)(this.composter.getCompostingPercent() * 100.0f);
        }
        if (Math.round(this.composter.getBiomeTemperature()) != this.lastBiomeTemperature || this.initialUpdate) {
            for (Object crafter : this.field_75149_d) {
                ((ICrafting)crafter).func_71112_a((Container)this, 2, Math.round(this.composter.getBiomeTemperature()));
            }
            this.lastBiomeTemperature = (byte)Math.round(this.composter.getBiomeTemperature());
        }
        this.initialUpdate = false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int value) {
        super.func_75137_b(id, value);
        switch (id) {
            case 1: {
                this.composter.setCompostingPercent((float)value / 100.0f);
                break;
            }
            case 2: {
                this.composter.biomeTemperature = value;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected composter progress bar id: " + id);
            }
        }
    }
}

