/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.integration.pams;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import squeek.veganoption.ModInfo;
import squeek.veganoption.VeganOption;
import squeek.veganoption.content.Modifiers;
import squeek.veganoption.content.modules.PlantMilk;
import squeek.veganoption.content.recipes.InputItemStack;
import squeek.veganoption.content.recipes.PistonCraftingRecipe;
import squeek.veganoption.content.registry.CompostRegistry;
import squeek.veganoption.content.registry.PistonCraftingRegistry;
import squeek.veganoption.helpers.TooltipHelper;
import squeek.veganoption.integration.IntegratorBase;

public class HarvestCraft
extends IntegratorBase {
    public static final String rootPackage = "com.pam.harvestcraft.";
    public static Item bbqSauce;
    public static Item bbqTofu;

    @Override
    public void create() {
        bbqSauce = new Item().func_77655_b("VeganOption.bbqSauce").func_77637_a(VeganOption.creativeTab).func_111206_d(ModInfo.MODID_LOWER + ":bbq_sauce");
        GameRegistry.registerItem((Item)bbqSauce, (String)"bbqSauce");
        bbqTofu = new ItemFood(14, 1.0f, false).func_77655_b("VeganOption.bbqTofu").func_77637_a(VeganOption.creativeTab).func_111206_d(ModInfo.MODID_LOWER + ":bbq_tofu");
        GameRegistry.registerItem((Item)bbqTofu, (String)"bbqTofu");
        TooltipHelper.registerItem(bbqTofu);
    }

    @Override
    public void oredict() {
        OreDictionary.registerOre((String)"presserOil", (ItemStack)new ItemStack(this.getItem("juicerItem")));
        OreDictionary.registerOre((String)"bakingEgg", (ItemStack)new ItemStack(this.getItem("firmtofuItem")));
        OreDictionary.registerOre((String)"foodBBQSauce", (ItemStack)new ItemStack(bbqSauce));
    }

    @Override
    public void recipes() {
        String[] foodNamesToExclude;
        Item freshMilkItem = this.getItem("freshmilkItem");
        if (freshMilkItem != null) {
            Modifiers.recipes.excludeOutput(new ItemStack(freshMilkItem));
        }
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(freshMilkItem, 4), (Object[])new Object[]{PlantMilk.bucketPlantMilk});
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(bbqSauce), new Object[]{"toolSaucepan", "foodKetchup", "foodVinegar", Items.field_151102_aT, "foodMustard", "listAllwater", "foodSalt", "foodBlackpepper"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(bbqTofu), new Object[]{"toolBakeware", "foodFirmtofu", "foodBBQSauce"}));
        if (this.getItem("doughItem") != null) {
            PistonCraftingRegistry.register(new PistonCraftingRecipe(this.getItem("doughItem"), FluidRegistry.WATER, "foodFlour", "foodSalt"));
        }
        if (this.getItem("batterItem") != null) {
            PistonCraftingRegistry.register(new PistonCraftingRecipe(this.getItem("batterItem"), "foodFlour", "bakingEgg"));
        }
        if (this.getItem("mashedpotatoesItem") != null) {
            PistonCraftingRegistry.register(new PistonCraftingRecipe(this.getItem("mashedpotatoesItem"), "foodButteredpotato", "foodSalt"));
        }
        for (String foodNameToExclude : foodNamesToExclude = new String[]{"boiledeggItem", "scrambledeggItem", "friedriceItem", "stuffedeggplantItem", "asparagusquicheItem", "custardItem", "omeletItem", "marshmellowsItem", "mayoItem", "coconutshrimpItem", "eggnogItem", "zucchinifriesItem", "friedeggItem"}) {
            Item item = this.getItem(foodNameToExclude);
            if (item == null) continue;
            Modifiers.recipes.excludeOutput(new ItemStack(item));
        }
    }

    @Override
    public void init() {
        super.init();
        CompostRegistry.blacklist(new CompostRegistry.FoodSpecifier(){

            @Override
            public boolean matches(ItemStack itemStack) {
                int[] oreIDs;
                for (int oreID : oreIDs = OreDictionary.getOreIDs((ItemStack)itemStack)) {
                    String oreName = OreDictionary.getOreName((int)oreID);
                    if (!oreName.startsWith("food")) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public void postInit() {
        super.postInit();
        for (ItemStack juice : OreDictionary.getOres((String)"listAlljuice")) {
            if (juice.func_77973_b() == null || juice.func_77973_b().hasContainerItem(juice)) continue;
            ArrayList<InputItemStack> juiceInputs = new ArrayList<InputItemStack>();
            List recipes = CraftingManager.func_77594_a().func_77592_b();
            for (IRecipe recipe : recipes) {
                if (recipe.func_77571_b() == null || !OreDictionary.itemMatches((ItemStack)juice, (ItemStack)recipe.func_77571_b(), (boolean)false)) continue;
                List ingredients = null;
                if (recipe instanceof ShapelessRecipes) {
                    ingredients = ((ShapelessRecipes)recipe).field_77579_b;
                } else {
                    if (!(recipe instanceof ShapelessOreRecipe)) continue;
                    ingredients = ((ShapelessOreRecipe)recipe).getInput();
                }
                for (Object ingredient : ingredients) {
                    if (ingredient instanceof ItemStack && ((ItemStack)ingredient).func_77973_b() == this.getItem("juicerItem") || ingredient instanceof ArrayList && ingredient == OreDictionary.getOres((String)"toolJuicer")) continue;
                    juiceInputs.add(new InputItemStack(ingredient));
                }
            }
            PistonCraftingRegistry.register(new PistonCraftingRecipe(juice.func_77946_l(), juiceInputs.toArray()));
        }
    }
}

