/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.integration.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;
import squeek.veganoption.content.recipes.InputItemStack;
import squeek.veganoption.content.recipes.PistonCraftingRecipe;
import squeek.veganoption.content.registry.PistonCraftingRegistry;
import squeek.veganoption.helpers.FluidHelper;
import squeek.veganoption.helpers.LangHelper;

public class PistonCraftingHandler
extends TemplateRecipeHandler {
    public static final FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
    public static final int WIDTH = 166;
    public static final int PADDING = 4;
    public static final Point startPoint = new Point(83, 16);
    public static Item pistonItem = Item.func_150898_a((Block)Blocks.field_150331_J);
    public static final PositionedStack pistonStack = new PositionedStack((Object)new ItemStack((Block)Blocks.field_150331_J), PistonCraftingHandler.startPoint.x - 9, PistonCraftingHandler.startPoint.y + 4, false);
    ItemStack itemStack = null;

    public void loadCraftingRecipes(String outputId, Object ... results) {
        List<PistonCraftingRecipe> recipes = null;
        if (outputId.equals(this.getOverlayIdentifier())) {
            recipes = PistonCraftingRegistry.getRecipes();
        } else if (outputId.equals("item") || outputId.equals("liquid")) {
            for (Object result : results) {
                ItemStack itemStackToCheck = null;
                if (result instanceof ItemStack) {
                    itemStackToCheck = (ItemStack)result;
                } else if (result instanceof FluidStack) {
                    itemStackToCheck = FluidHelper.toItemStack((FluidStack)result);
                }
                if (itemStackToCheck == null || !this.hasRecipe(itemStackToCheck)) continue;
                this.itemStack = itemStackToCheck.func_77946_l();
                this.itemStack.field_77994_a = 1;
                recipes = PistonCraftingRegistry.getSubsetByOutput(this.itemStack);
                break;
            }
        }
        if (recipes != null) {
            this.loadRecipes(recipes);
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        List<PistonCraftingRecipe> recipes = null;
        if (inputId.equals(this.getOverlayIdentifier())) {
            recipes = PistonCraftingRegistry.getRecipes();
        } else if (inputId.equals("item") || inputId.equals("liquid")) {
            for (Object ingredient : ingredients) {
                ItemStack itemStackToCheck = null;
                if (ingredient instanceof ItemStack) {
                    itemStackToCheck = (ItemStack)ingredient;
                } else if (ingredient instanceof FluidStack) {
                    itemStackToCheck = FluidHelper.toItemStack((FluidStack)ingredient);
                }
                if (itemStackToCheck == null || !this.hasUsage(itemStackToCheck)) continue;
                this.itemStack = itemStackToCheck.func_77946_l();
                this.itemStack.field_77994_a = 1;
                if (this.itemStack.func_77973_b() == pistonItem) {
                    recipes = PistonCraftingRegistry.getRecipes();
                    break;
                }
                recipes = PistonCraftingRegistry.getSubsetByInput(this.itemStack);
                break;
            }
        }
        if (recipes != null) {
            this.loadRecipes(recipes);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadRecipes(Collection<PistonCraftingRecipe> recipes) {
        for (PistonCraftingRecipe recipe : recipes) {
            CachedPistonCraftingRecipe cachedRecipe = new CachedPistonCraftingRecipe(recipe);
            cachedRecipe.computeVisuals();
            if (this.itemStack != null && cachedRecipe.contains(cachedRecipe.ingredients, this.itemStack)) {
                cachedRecipe.setIngredientPermutation(cachedRecipe.ingredients, this.itemStack);
            }
            this.arecipes.add(cachedRecipe);
        }
    }

    public boolean hasUsage(ItemStack itemStack) {
        if (itemStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150331_J)) {
            return true;
        }
        for (PistonCraftingRecipe recipe : PistonCraftingRegistry.getRecipes()) {
            for (InputItemStack input : recipe.itemInputs) {
                if (!input.matches(itemStack)) continue;
                return true;
            }
            if (recipe.fluidInput == null || !recipe.fluidInput.isFluidEqual(FluidHelper.fromItemStack(itemStack))) continue;
            return true;
        }
        return false;
    }

    public boolean hasRecipe(ItemStack itemStack) {
        for (PistonCraftingRecipe recipe : PistonCraftingRegistry.getRecipes()) {
            for (ItemStack output : recipe.itemOutputs) {
                if (!OreDictionary.itemMatches((ItemStack)output, (ItemStack)itemStack, (boolean)true)) continue;
                return true;
            }
            if (recipe.fluidOutput == null || !recipe.fluidOutput.isFluidEqual(FluidHelper.fromItemStack(itemStack))) continue;
            return true;
        }
        return false;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(PistonCraftingHandler.startPoint.x + 4, PistonCraftingHandler.startPoint.y + 4, 24, 15), this.getOverlayIdentifier(), new Object[0]));
        super.loadTransferRects();
    }

    public String getOverlayIdentifier() {
        return "VeganOption.pistonCrafting";
    }

    public String getRecipeName() {
        return LangHelper.translate("nei.pistonCrafting");
    }

    public Point getRecipePosition(int recipe) {
        return startPoint;
    }

    public List<String> styleFluidTooltip(List<String> tooltip) {
        for (int i = 0; i < tooltip.size(); ++i) {
            tooltip.set(i, EnumChatFormatting.GOLD + EnumChatFormatting.ITALIC.toString() + tooltip.get(i) + EnumChatFormatting.RESET);
        }
        return tooltip;
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> currenttip, int recipeIndex) {
        if (FluidHelper.fromItemStack(stack) == null) {
            return super.handleItemTooltip(gui, stack, currenttip, recipeIndex);
        }
        CachedPistonCraftingRecipe cachedRecipe = (CachedPistonCraftingRecipe)((Object)this.arecipes.get(recipeIndex));
        if (gui.isMouseOver(cachedRecipe.result, recipeIndex)) {
            List splitFluidOutputTooltip = fontRenderer.func_78271_c(LangHelper.translate("nei.pistonCrafting.tooltip.fluidOutput"), 166);
            this.styleFluidTooltip(splitFluidOutputTooltip);
            currenttip.addAll(splitFluidOutputTooltip);
        } else {
            for (PositionedStack positionedIngredient : cachedRecipe.ingredients) {
                if (!gui.isMouseOver(positionedIngredient, recipeIndex)) continue;
                List splitFluidInputTooltip = fontRenderer.func_78271_c(LangHelper.translate("nei.pistonCrafting.tooltip.fluidInput"), 166);
                this.styleFluidTooltip(splitFluidInputTooltip);
                currenttip.addAll(splitFluidInputTooltip);
                break;
            }
        }
        return super.handleItemTooltip(gui, stack, currenttip, recipeIndex);
    }

    public void drawBackground(int recipe) {
        Point recipePos = this.getRecipePosition(recipe);
        int x = recipePos.x;
        int y = recipePos.y;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)"textures/gui/container/furnace.png");
        GuiDraw.drawTexturedModalRect((int)(x + 4), (int)(y + 4), (int)79, (int)35, (int)24, (int)15);
        this.drawProgressBar(x + 4, y + 4, 176, 14, 24, 15, 20, 0);
        GuiDraw.drawTexturedModalRect((int)(x + 36 - 1), (int)(y - 1), (int)111, (int)30, (int)26, (int)26);
        CachedPistonCraftingRecipe cachedRecipe = (CachedPistonCraftingRecipe)((Object)this.arecipes.get(recipe));
        for (PositionedStack ingredient : cachedRecipe.ingredients) {
            GuiDraw.drawTexturedModalRect((int)(ingredient.relx - 1), (int)(ingredient.rely - 1), (int)55, (int)16, (int)18, (int)18);
        }
    }

    public void drawForeground(int recipe) {
    }

    public int recipiesPerPage() {
        return 2;
    }

    public String getGuiTexture() {
        return null;
    }

    public class CachedPistonCraftingRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public List<PositionedStack> ingredients;
        public List<PositionedStack> other;
        public PositionedStack result;

        public CachedPistonCraftingRecipe(PistonCraftingRecipe recipe) {
            int width;
            super((TemplateRecipeHandler)PistonCraftingHandler.this);
            this.ingredients = new ArrayList<PositionedStack>();
            this.other = new ArrayList<PositionedStack>();
            ItemStack resultAsItemStack = recipe.itemOutputs.size() > 0 ? recipe.itemOutputs.get(0) : FluidHelper.toItemStack(recipe.fluidOutput);
            this.result = new PositionedStack((Object)resultAsItemStack, PistonCraftingHandler.startPoint.x + 36 + 4, PistonCraftingHandler.startPoint.y + 4, false);
            int numIngredients = recipe.itemInputs.size() + (recipe.fluidInput != null ? 1 : 0);
            int n = numIngredients <= 1 ? 1 : (width = numIngredients <= 4 ? 2 : 3);
            int height = numIngredients <= 2 ? 1 : (numIngredients <= 6 ? 2 : 3);
            Object[] ingredientsArray = new Object[width * height];
            int i = 0;
            for (InputItemStack input : recipe.itemInputs) {
                if (input.wrappedItemStack != null) {
                    ingredientsArray[i++] = input.wrappedItemStack;
                    continue;
                }
                if (input.oreDictItemStacks == null) continue;
                if (input.stackSize() == 1) {
                    ingredientsArray[i++] = input.oreDictItemStacks;
                    continue;
                }
                ArrayList<ItemStack> oreDictItemStacksWithCorrectStackSize = new ArrayList<ItemStack>();
                for (ItemStack inputStack : input.oreDictItemStacks) {
                    ItemStack inputWithCorrectStackSize = inputStack.func_77946_l();
                    inputWithCorrectStackSize.field_77994_a = input.stackSize();
                    oreDictItemStacksWithCorrectStackSize.add(inputWithCorrectStackSize);
                }
                ingredientsArray[i++] = oreDictItemStacksWithCorrectStackSize;
            }
            if (recipe.fluidInput != null) {
                ingredientsArray[i++] = FluidHelper.toItemStack(recipe.fluidInput);
            }
            this.setIngredients(width, height, ingredientsArray);
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public void setIngredients(int width, int height, Object[] items) {
            int maxWidth = 54;
            int startX = PistonCraftingHandler.startPoint.x - 27 - maxWidth / 2 - 18 * (width - 1) / 2;
            int startY = PistonCraftingHandler.startPoint.y + 4 - 18 * (height - 1) / 2;
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (items[y * width + x] == null) continue;
                    PositionedStack stack = new PositionedStack(items[y * width + x], startX + x * 18, startY + y * 18, false);
                    this.ingredients.add(stack);
                }
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(PistonCraftingHandler.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getOtherStack() {
            return pistonStack;
        }

        public List<PositionedStack> getOtherStacks() {
            List otherStacks = super.getOtherStacks();
            otherStacks.addAll(this.other);
            return otherStacks;
        }

        public void computeVisuals() {
            for (PositionedStack p : this.ingredients) {
                p.generatePermutations();
            }
        }
    }
}

