/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.integration.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;
import squeek.veganoption.content.modules.Composting;
import squeek.veganoption.content.registry.CompostRegistry;
import squeek.veganoption.helpers.LangHelper;

public class CompostHandler
extends TemplateRecipeHandler {
    public static final FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
    public static final int WIDTH = 166;
    public static final int PADDING = 4;
    ItemStack itemStack = null;
    boolean isUsage;

    public CompostHandler() {
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(87, 16, 22, 15), this.getOverlayIdentifier(), new Object[0]));
        super.loadTransferRects();
    }

    public String getOverlayIdentifier() {
        return "VeganOption.composting";
    }

    public CompostHandler(ItemStack itemStack, boolean isUsage) {
        this.itemStack = itemStack.func_77946_l();
        this.itemStack.field_77994_a = 1;
        this.isUsage = isUsage;
    }

    public ICraftingHandler getRecipeHandler(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            return new CompostHandler(new ItemStack(Composting.composter), true);
        }
        if (outputId.equals("item")) {
            for (Object result : results) {
                if (!(result instanceof ItemStack) || !this.isCompostResult((ItemStack)result)) continue;
                return new CompostHandler((ItemStack)result, false);
            }
        }
        return super.getRecipeHandler(outputId, results);
    }

    public IUsageHandler getUsageHandler(String inputId, Object ... ingredients) {
        if (inputId.equals(this.getOverlayIdentifier())) {
            return new CompostHandler(new ItemStack(Composting.composter), true);
        }
        if (inputId.equals("item")) {
            for (Object ingredient : ingredients) {
                if (ingredient instanceof ItemStack && CompostRegistry.isCompostable((ItemStack)ingredient)) {
                    return new CompostHandler((ItemStack)ingredient, true);
                }
                if (!(ingredient instanceof ItemStack) || ((ItemStack)ingredient).func_77973_b() != Item.func_150898_a((Block)Composting.composter)) continue;
                return new CompostHandler((ItemStack)ingredient, true);
            }
        }
        return super.getUsageHandler(inputId, ingredients);
    }

    public boolean isCompostResult(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() != null && (itemStack.func_77969_a(new ItemStack(Composting.compost)) || itemStack.func_77973_b() == Composting.rottenPlants);
    }

    public String getRecipeName() {
        return LangHelper.translate("nei.composting");
    }

    public int numRecipes() {
        if (this.itemStack != null) {
            if (this.isCompostResult(this.itemStack) || CompostRegistry.isBrown(this.itemStack)) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public Point getRecipePosition(int recipe) {
        return new Point(83, 16);
    }

    public void drawBackground(int recipe) {
        Point recipePos = this.getRecipePosition(recipe);
        int x = recipePos.x;
        int y = recipePos.y;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)"textures/gui/container/crafting_table.png");
        GuiDraw.drawTexturedModalRect((int)(x + 4), (int)(y + 4), (int)90, (int)35, (int)22, (int)15);
        GuiDraw.drawTexturedModalRect((int)(x + 36 - 1), (int)(y - 2), (int)119, (int)29, (int)26, (int)27);
        GL11.glColor4f((float)0.75f, (float)1.0f, (float)0.75f, (float)1.0f);
        GuiDraw.drawTexturedModalRect((int)(x - 36 - 1), (int)((y += 4) - 1), (int)47, (int)34, (int)18, (int)18);
        GuiDraw.drawTexturedModalRect((int)(x - 54 - 1), (int)(y - 1), (int)47, (int)34, (int)18, (int)18);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.75f, (float)1.0f);
        GuiDraw.drawTexturedModalRect((int)(x - 72 - 1), (int)(y - 1), (int)47, (int)34, (int)18, (int)18);
    }

    public void drawForeground(int recipe) {
    }

    public List<PositionedStack> getIngredientStacks(int recipe) {
        ArrayList<PositionedStack> positionedStacks = new ArrayList<PositionedStack>();
        int ticksPerStackSize = 20;
        int curGreen = this.cycleticks / ticksPerStackSize % CompostRegistry.greens.size();
        Point recipePos = this.getRecipePosition(recipe);
        int x = recipePos.x - 36;
        int y = recipePos.y + 4;
        ItemStack greenStack = CompostRegistry.isGreen(this.itemStack) && this.isUsage ? this.itemStack : CompostRegistry.greens.get(curGreen).func_77946_l();
        positionedStacks.add(new PositionedStack((Object)greenStack, x, y, false));
        if (recipe == 0 && (this.isUsage || this.itemStack == null || this.itemStack.func_77973_b() != Composting.rottenPlants)) {
            int curSecondGreen = (curGreen + 1) % CompostRegistry.greens.size();
            int curBrown = this.cycleticks / ticksPerStackSize % CompostRegistry.browns.size();
            ItemStack brownStack = CompostRegistry.isBrown(this.itemStack) && this.isUsage ? this.itemStack : CompostRegistry.browns.get(curBrown).func_77946_l();
            positionedStacks.add(new PositionedStack((Object)CompostRegistry.greens.get(curSecondGreen).func_77946_l(), x -= 18, y, false));
            positionedStacks.add(new PositionedStack((Object)brownStack, x -= 18, y, false));
        }
        return positionedStacks;
    }

    public List<PositionedStack> getOtherStacks(int recipe) {
        ArrayList<PositionedStack> positionedStacks = new ArrayList<PositionedStack>();
        Point recipePos = this.getRecipePosition(recipe);
        int x = recipePos.x - 9;
        int y = recipePos.y + 4;
        positionedStacks.add(new PositionedStack((Object)new ItemStack(Composting.composter), x, y, false));
        return positionedStacks;
    }

    public PositionedStack getResultStack(int recipe) {
        Point recipePos = this.getRecipePosition(recipe);
        int x = recipePos.x + 36 + 4;
        int y = recipePos.y + 4;
        ItemStack result = recipe == 0 && (this.isUsage || this.itemStack == null || this.itemStack.func_77973_b() != Composting.rottenPlants) ? new ItemStack(Composting.compost) : new ItemStack(Composting.rottenPlants);
        return new PositionedStack((Object)result, x, y, false);
    }

    public int recipiesPerPage() {
        return 2;
    }

    public String getGuiTexture() {
        return null;
    }
}

