/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.integration.cofh;

import cpw.mods.fml.common.event.FMLInterModComms;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import squeek.veganoption.content.modules.Egg;
import squeek.veganoption.content.modules.Ender;
import squeek.veganoption.content.modules.FrozenBubble;
import squeek.veganoption.content.modules.Seitan;
import squeek.veganoption.integration.IntegratorBase;

public class ThermalExpansion
extends IntegratorBase {
    public static final int RESONANT_ENDER_PER_PEARL = 250;
    public static final String RESONANT_ENDER_FLUID_NAME = "ender";

    @Override
    public void init() {
        super.init();
        ThermalExpansion.addTransposerFill(4000, new ItemStack(FrozenBubble.frozenBubble), new ItemStack(Items.field_151079_bi), new FluidStack(Ender.fluidRawEnder, Ender.RAW_ENDER_PER_PEARL), true);
        ThermalExpansion.addTransposerFill(4000, new ItemStack(FrozenBubble.frozenBubble), new ItemStack(Items.field_151079_bi), FluidRegistry.getFluidStack((String)RESONANT_ENDER_FLUID_NAME, (int)250), false);
        ThermalExpansion.addTransposerFill(2000, Seitan.wheatFlourStack.func_77946_l(), Seitan.wheatDoughStack.func_77946_l(), new FluidStack(FluidRegistry.WATER, 1000), false);
        ThermalExpansion.addTransposerFill(2000, Seitan.wheatDoughStack.func_77946_l(), Seitan.seitanUnwashedStack.func_77946_l(), new FluidStack(FluidRegistry.WATER, 1000), false);
        for (int outputMeta = 3; outputMeta < 6; ++outputMeta) {
            ThermalExpansion.addTransposerFill(2000, new ItemStack(Seitan.washableWheat, 1, outputMeta - 1), new ItemStack(Seitan.washableWheat, 1, outputMeta), new FluidStack(FluidRegistry.WATER, 1000), false);
        }
        ThermalExpansion.addTransposerFill(2000, new ItemStack(Seitan.washableWheat, 1, 5), Seitan.seitanRawStack.func_77946_l(), new FluidStack(FluidRegistry.WATER, 1000), false);
        ThermalExpansion.addPulverizerRecipe(1600, new ItemStack(Items.field_151174_bG), new ItemStack(Egg.potatoStarch, 2), null, 100);
    }

    public static void addTransposerFill(int energy, ItemStack input, ItemStack output, FluidStack fluid, boolean reversible) {
        if (input == null || output == null || fluid == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", energy);
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("output", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("fluid", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        output.func_77955_b(toSend.func_74775_l("output"));
        toSend.func_74757_a("reversible", reversible);
        fluid.writeToNBT(toSend.func_74775_l("fluid"));
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"TransposerFillRecipe", (NBTTagCompound)toSend);
    }

    public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (input == null || primaryOutput == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", energy);
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("primaryOutput", (NBTBase)new NBTTagCompound());
        if (secondaryOutput != null) {
            toSend.func_74782_a("secondaryOutput", (NBTBase)new NBTTagCompound());
        }
        input.func_77955_b(toSend.func_74775_l("input"));
        primaryOutput.func_77955_b(toSend.func_74775_l("primaryOutput"));
        if (secondaryOutput != null) {
            secondaryOutput.func_77955_b(toSend.func_74775_l("secondaryOutput"));
            toSend.func_74768_a("secondaryChance", secondaryChance);
        }
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"PulverizerRecipe", (NBTTagCompound)toSend);
    }
}

