/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.integration;

import cpw.mods.fml.common.Loader;
import java.util.HashMap;
import java.util.Map;
import squeek.veganoption.integration.IntegrationBase;
import squeek.veganoption.integration.IntegratorBase;

public class IntegrationHandler
extends IntegrationBase {
    private static Map<String, IntegratorBase> integrators = new HashMap<String, IntegratorBase>();

    public static void preInit() {
        for (IntegratorBase integrator : integrators.values()) {
            integrator.preInit();
        }
    }

    public static void init() {
        for (IntegratorBase integrator : integrators.values()) {
            integrator.init();
        }
    }

    public static void postInit() {
        for (IntegratorBase integrator : integrators.values()) {
            integrator.postInit();
        }
    }

    public static boolean tryIntegration(String modID, String packageName) {
        return IntegrationHandler.tryIntegration(modID, packageName, modID);
    }

    public static boolean tryIntegration(String modID, String packageName, String className) {
        if (Loader.isModLoaded((String)modID)) {
            try {
                String fullClassName = "squeek.veganoption.integration." + packageName + "." + className;
                Class<?> clazz = Class.forName(fullClassName);
                IntegratorBase integrator = (IntegratorBase)clazz.newInstance();
                integrator.modID = modID;
                integrators.put(modID, integrator);
                return true;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public static boolean integratorExists(String modID) {
        return integrators.containsKey(modID);
    }

    static {
        IntegrationHandler.tryIntegration("ThermalExpansion", "cofh");
        IntegrationHandler.tryIntegration("harvestcraft", "pams", "HarvestCraft");
        IntegrationHandler.tryIntegration("MineFactoryReloaded", "mfr");
        IntegrationHandler.tryIntegration("TConstruct", "tic");
        IntegrationHandler.tryIntegration("IguanaTweaksTConstruct", "tic");
        IntegrationHandler.tryIntegration("witchery", "witchery", "Witchery");
        IntegrationHandler.tryIntegration("Waila", "waila");
        IntegrationHandler.tryIntegration("VersionChecker", "versionchecker");
        IntegrationHandler.tryIntegration("Thaumcraft", "thaumcraft");
        IntegrationHandler.tryIntegration("TwilightForest", "twilightforest");
        IntegrationHandler.tryIntegration("Natura", "natura");
        IntegrationHandler.tryIntegration("ExtraTrees", "forestry");
        IntegrationHandler.tryIntegration("BiomesOPlenty", "bop");
        IntegrationHandler.tryIntegration("FoodPlus", "foodplus");
        IntegrationHandler.tryIntegration("stillhungry", "stillhungry", "StillHungry");
        IntegrationHandler.tryIntegration("magicalcrops", "magicalcrops", "MagicalCrops");
        IntegrationHandler.tryIntegration("Mystcraft", "mystcraft");
    }
}

