/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.helpers;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;
import squeek.veganoption.helpers.BlockHelper;

public class FluidHelper {
    public static final int FINITE_FLUID_MB_PER_META = 125;

    public static ItemStack toItemStack(FluidStack fluidStack) {
        if (fluidStack == null || fluidStack.getFluid() == null || fluidStack.getFluid().getBlock() == null) {
            return null;
        }
        return new ItemStack(fluidStack.getFluid().getBlock());
    }

    public static FluidStack fromItemStack(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77973_b() == null || Block.func_149634_a((Item)itemStack.func_77973_b()) == null) {
            return null;
        }
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        Fluid fluid = FluidHelper.getFluidTypeOfBlock(block);
        return fluid != null ? new FluidStack(fluid, 1000) : null;
    }

    public static boolean isBlockMaterialWater(Block block) {
        return block != null && block.func_149688_o() == Material.field_151586_h;
    }

    public static boolean isBlockMaterialLava(Block block) {
        return block != null && block.func_149688_o() == Material.field_151587_i;
    }

    public static Fluid getFluidTypeOfBlock(Block block) {
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
        if (fluid != null) {
            return fluid;
        }
        if (FluidHelper.isBlockMaterialWater(block)) {
            return FluidRegistry.WATER;
        }
        if (FluidHelper.isBlockMaterialLava(block)) {
            return FluidRegistry.LAVA;
        }
        return null;
    }

    public static int getStillMetadata(Fluid fluid) {
        if (fluid != null && fluid.getBlock() instanceof BlockFluidFinite) {
            return 7;
        }
        return 0;
    }

    public static FluidStack getFluidStackFromBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof IFluidBlock) {
            return ((IFluidBlock)block).drain(world, x, y, z, false);
        }
        return FluidHelper.getFluidStackFromBlock(block, world.func_72805_g(x, y, z));
    }

    public static FluidStack getFluidStackFromBlock(Block block, int metadata) {
        Fluid fluid = FluidHelper.getFluidTypeOfBlock(block);
        if (fluid != null && metadata == FluidHelper.getStillMetadata(fluid)) {
            return new FluidStack(fluid, 1000);
        }
        return null;
    }

    public static FluidStack consumeExactFluid(BlockHelper.BlockPos blockPos, Fluid fluid, int amount) {
        return FluidHelper.consumeFluid(blockPos, fluid, amount, amount);
    }

    public static FluidStack consumeFluid(BlockHelper.BlockPos blockPos, Fluid fluid, int maxAmount) {
        FluidStack consumed = FluidHelper.consumeFluid(blockPos, fluid, 0, maxAmount);
        return consumed != null && consumed.amount > 0 ? consumed : null;
    }

    public static FluidStack consumeFluid(BlockHelper.BlockPos blockPos, Fluid fluid, int minAmount, int maxAmount) {
        IFluidHandler fluidHandler;
        FluidStack stackDrained;
        if (blockPos.world.field_72995_K) {
            return null;
        }
        if (maxAmount < minAmount) {
            return null;
        }
        if (blockPos.getTile() instanceof IFluidHandler && (stackDrained = (fluidHandler = (IFluidHandler)blockPos.getTile()).drain(ForgeDirection.UP, new FluidStack(fluid, maxAmount), false)) != null && stackDrained.amount >= minAmount) {
            return fluidHandler.drain(ForgeDirection.UP, stackDrained, true);
        }
        BlockHelper.BlockPos sourcePos = BlockHelper.followFluidStreamToSourceBlock(blockPos, fluid);
        if (sourcePos == null) {
            return null;
        }
        FluidStack fluidToAdd = FluidHelper.getFluidStackFromBlock(sourcePos.world, sourcePos.x, sourcePos.y, sourcePos.z);
        if (fluidToAdd == null) {
            return null;
        }
        if (fluidToAdd.amount > maxAmount) {
            if (sourcePos.getBlock() instanceof BlockFluidFinite) {
                fluidToAdd = FluidHelper.consumePartialFiniteFluidBlock(sourcePos, fluidToAdd, maxAmount);
            } else {
                return null;
            }
        }
        if (fluidToAdd.amount >= minAmount && fluidToAdd.amount <= maxAmount) {
            sourcePos.world.func_147468_f(sourcePos.x, sourcePos.y, sourcePos.z);
            return fluidToAdd;
        }
        return null;
    }

    public static FluidStack consumePartialFiniteFluidBlock(BlockHelper.BlockPos fluidBlockPos, int maxAmount) {
        return FluidHelper.consumePartialFiniteFluidBlock(fluidBlockPos, FluidHelper.getFluidStackFromBlock(fluidBlockPos.world, fluidBlockPos.x, fluidBlockPos.y, fluidBlockPos.z), maxAmount);
    }

    public static FluidStack consumePartialFiniteFluidBlock(BlockHelper.BlockPos fluidBlockPos, FluidStack fullFluidStack, int maxAmount) {
        if (fluidBlockPos.world.field_72995_K) {
            return null;
        }
        int deltaMeta = -(maxAmount / 125);
        int newMeta = fluidBlockPos.getMeta() + deltaMeta;
        if (deltaMeta == 0) {
            return null;
        }
        FluidStack fluidConsumed = fullFluidStack.copy();
        fluidConsumed.amount = Math.abs(deltaMeta) * 125;
        if (newMeta >= 0) {
            fluidBlockPos.world.func_72921_c(fluidBlockPos.x, fluidBlockPos.y, fluidBlockPos.z, newMeta, 2);
        } else {
            fluidBlockPos.world.func_147468_f(fluidBlockPos.x, fluidBlockPos.y, fluidBlockPos.z);
        }
        return fluidConsumed;
    }
}

