/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.helpers;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import squeek.veganoption.blocks.BlockFluidGeneric;
import squeek.veganoption.content.modules.Ender;

public class FluidContainerHelper {
    protected static Method getMovingObjectPositionFromPlayer = ReflectionHelper.findMethod(Item.class, null, (String[])new String[]{"getMovingObjectPositionFromPlayer", "func_77621_a", "a"}, (Class[])new Class[]{World.class, EntityPlayer.class, Boolean.TYPE});

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new FluidContainerHelper());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onFillBucket(FillBucketEvent event) {
        if (event.isCanceled() || event.getResult() != Event.Result.DEFAULT) {
            return;
        }
        Block block = event.world.func_147439_a(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d);
        if (block instanceof BlockFluidGeneric) {
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        boolean didFill;
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.action != PlayerInteractEvent.Action.RIGHT_CLICK_AIR) {
            return;
        }
        if (event.isCanceled() || event.useItem != Event.Result.DEFAULT) {
            return;
        }
        if (event.entityPlayer.func_70694_bm() == null) {
            return;
        }
        if (event.entityPlayer.func_70694_bm().func_77973_b() != Items.field_151069_bo) {
            return;
        }
        ItemStack emptyContainer = event.entityPlayer.func_70694_bm();
        MovingObjectPosition movingObjectPosition = null;
        try {
            movingObjectPosition = (MovingObjectPosition)getMovingObjectPositionFromPlayer.invoke((Object)emptyContainer.func_77973_b(), event.world, event.entityPlayer, true);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (movingObjectPosition == null) {
            return;
        }
        if (movingObjectPosition.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return;
        }
        int x = movingObjectPosition.field_72311_b;
        int y = movingObjectPosition.field_72312_c;
        int z = movingObjectPosition.field_72309_d;
        Block block = event.world.func_147439_a(x, y, z);
        if (block == Ender.rawEnder) {
            event.setCanceled(true);
            event.useItem = Event.Result.DENY;
            return;
        }
        if (!(block instanceof BlockFluidGeneric)) {
            return;
        }
        if (!event.world.func_72962_a(event.entityPlayer, x, y, z)) {
            return;
        }
        if (!event.entityPlayer.func_82247_a(x, y, z, movingObjectPosition.field_72310_e, emptyContainer)) {
            return;
        }
        FluidStack fluidStack = new FluidStack(((BlockFluidGeneric)block).getFluid(), 1000);
        boolean bl = didFill = FluidContainerHelper.tryFillContainer(event.entityPlayer, emptyContainer, fluidStack) != null;
        if (!didFill) {
            event.setCanceled(true);
            event.useItem = Event.Result.DENY;
        } else {
            event.world.func_147468_f(x, y, z);
        }
    }

    public static ItemStack tryFillContainer(EntityPlayer player, ItemStack emptyContainer, FluidStack fluidStack) {
        ItemStack filledContainer = FluidContainerRegistry.fillFluidContainer((FluidStack)fluidStack, (ItemStack)emptyContainer);
        if (filledContainer == null) {
            return null;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            --emptyContainer.field_77994_a;
            if (emptyContainer.field_77994_a <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, filledContainer);
                if (!player.field_70170_p.field_72995_K) {
                    player.field_71069_bz.func_75142_b();
                }
            } else if (!player.field_71071_by.func_70441_a(filledContainer)) {
                player.func_71019_a(filledContainer, false);
            }
        }
        return filledContainer;
    }

    public static ItemStack tryEmptyContainer(EntityPlayer player, ItemStack filledContainer) {
        ItemStack emptyContainer = FluidContainerRegistry.drainFluidContainer((ItemStack)filledContainer);
        if (emptyContainer == null) {
            return null;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            --filledContainer.field_77994_a;
            if (filledContainer.field_77994_a <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, emptyContainer);
                if (!player.field_70170_p.field_72995_K) {
                    player.field_71069_bz.func_75142_b();
                }
            } else if (!player.field_71071_by.func_70441_a(emptyContainer)) {
                player.func_71019_a(emptyContainer, false);
            }
        }
        return emptyContainer;
    }
}

